% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_box.R
\name{tweet_box}
\alias{tweet_box}
\title{Twitter Data Box Plot}
\usage{
tweet_box(DataFrameTidyScores, HT_Topic)
}
\arguments{
\item{DataFrameTidyScores}{DataFrame of Twitter Data that has been tidy'd and scored.}

\item{HT_Topic}{If using hashtag data select:  "hashtag".  If using topic data select:  "topic".}
}
\value{
A ggplot box plot.
}
\description{
Displays the distribution scores of either hashtag or topic Twitter data.
}
\examples{
\donttest{
library(saotd)
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data, 
                           HT_Topic = "hashtag") 
ht_box <- tweet_box(DataFrameTidyScores = score_data,
                    HT_Topic = "hashtag")
ht_box
               
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data, 
                           HT_Topic = "topic") 
topic_box <- tweet_box(DataFrameTidyScores = score_data,
                       HT_Topic = "topic") 
topic_box                    
}
}
