% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b4m.R
\name{b4m}
\alias{b4m}
\title{Statistical power for a hyphotesis testing on a single mean}
\usage{
b4m(N, n, mu, sigma, D, DEFF = 1, conf = 0.95, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{mu}{The value of the estimated mean of the variable of interest.}

\item{sigma}{The value of the standard deviation of the variable of interest.}

\item{D}{The value of the null effect. Note that \code{D} must be strictly greater than \code{mu}.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{plot}{Optionally plot the power achieved for an specific sample size.}
}
\value{
The power of the test.
}
\description{
This function computes the power for a (right tail) test of means.
}
\details{
We note that the power is defined as: \deqn{1-\Phi(Z_{1-\alpha} - \frac{(D - \mu)}{\sqrt{\frac{1}{n}(1-\frac{n}{N})S^2}})}
where \deqn{S^2 = DEFF \sigma^2}
}
\examples{
b4m(N = 100000, n = 400, mu = 3, sigma = 1, D = 3.1)
b4m(N = 100000, n = 400, mu = 5, sigma = 10, D = 7, plot = TRUE)
b4m(N = 100000, n = 400, mu = 50, sigma = 100, D = 100, DEFF = 3.4, conf = 0.99, plot = TRUE)
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}

