% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survival}
\alias{survival}
\alias{survival,samc,missing-method}
\alias{survival,samc,RasterLayer-method}
\alias{survival,samc,matrix-method}
\title{Calculate survival metrics}
\usage{
survival(samc, occ)

\S4method{survival}{samc,missing}(samc)

\S4method{survival}{samc,RasterLayer}(samc, occ)

\S4method{survival}{samc,matrix}(samc, occ)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object. This should be output from
the \code{\link{samc}} function.}

\item{occ}{A \code{\link[raster]{RasterLayer-class}} or \code{\link[base]{matrix}}.
The input type must match the input type used to create the
\code{\link{samc-class}} object, and must have the same properties as the
rest of the landscape data. See the \code{\link{check}} function for more
details.}
}
\value{
A \code{vector} or a \code{numeric}
}
\description{
Calculates the expected amount of time that individuals survive
in the landscape.
}
\details{
\eqn{z=(I-Q)^{-1}{\cdot}1=F{\cdot}1}
\itemize{
  \item \strong{survival(samc)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. The value of element \emph{i} is the expected
amount of time that individuals survive when starting at location \emph{j}.
}

\eqn{\psi^Tz}
\itemize{
  \item \strong{survival(samc, occ)}

The result is a numeric that represents the expected time that any individual
stays in the landscape before death, regardless of the initial location.
}
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
