% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsert.R
\name{sf_upsert}
\alias{sf_upsert}
\title{Upsert Records}
\usage{
sf_upsert(
  input_data,
  object_name,
  external_id_fieldname,
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  guess_types = TRUE,
  control = list(...),
  ...,
  all_or_none = deprecated(),
  verbose = FALSE
)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; data can be coerced into a \code{data.frame}. If performing an
\code{update}, \code{upsert}, or \code{delete} operation, then one column or
field must be the \code{Id} of the record to modify or delete.}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{external_id_fieldname}{\code{character}; string identifying a custom field on the
object that has been set as an "External ID" field. This field is used to reference
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used, if \code{FALSE} then all fields will be returned
as character. This is helpful when \code{col_guess()} will mangle field values
in Salesforce that you'd like to preserve during translation into a \code{tbl_df},
like numeric looking values that must be preserved as strings ("48.0").}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream
to \code{\link{sf_bulk_operation}}}

\item{all_or_none}{\code{logical}; allows a call to roll back all changes unless all
records are processed successfully.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

Upserts one or more new records to your organization’s data.
}
\examples{
\dontrun{
n <- 2
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact-Create-", 1:n),
                       My_External_Id__c=letters[1:n])
new_contacts_result <- sf_create(new_contacts, object_name="Contact")

upserted_contacts <- tibble(FirstName = rep("Test", n),
                            LastName = paste0("Contact-Upsert-", 1:n),
                            My_External_Id__c=letters[1:n])
new_record <- tibble(FirstName = "Test",
                     LastName = paste0("Contact-Upsert-", n+1),
                     My_External_Id__c=letters[n+1])
upserted_contacts <- bind_rows(upserted_contacts, new_record)

upserted_contacts_result1 <- sf_upsert(upserted_contacts, 
                                       object_name="Contact", 
                                       "My_External_Id__c")
}
}
