% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-dashboard.R
\name{sf_dashboard_describe}
\alias{sf_dashboard_describe}
\title{Describe a dashboard}
\usage{
sf_dashboard_describe(dashboard_id, as_tbl = TRUE, verbose = FALSE)
}
\arguments{
\item{dashboard_id}{\code{character}; the Salesforce Id assigned to a created
dashboard. It will start with \code{"01Z"}.}

\item{as_tbl}{\code{logical}; an indicator of whether to convert the parsed
JSON into a \code{tbl_df}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list} or \code{tbl_df} depending on the value of argument \code{as_tbl}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

Returns metadata for the specified dashboard, including dashboard components,
filters, layout, and the running user.
}
\seealso{
\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/analytics_api_dashboard_describe_resource.htm}{Salesforce Documentation}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/analytics_api_dashboard_example_get_dashboard_metadata.htm#analytics_api_dashboard_example_get_dashboard_metadata}{Salesforce Example}
}
}
