% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsert-metadata.R
\name{sf_upsert_metadata}
\alias{sf_upsert_metadata}
\title{Upsert Object or Field Metadata in Salesforce}
\usage{
sf_upsert_metadata(metadata_type, metadata, all_or_none = FALSE,
  verbose = FALSE)
}
\arguments{
\item{metadata_type}{character; string on what type of metadata to create}

\item{metadata}{\code{list}; metadata components to be created formatted as 
XML before being sent via API}

\item{all_or_none}{logical; allows a call to roll back all changes unless all 
records are processed successfully}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} containing the creation result for each submitted metadata component
}
\description{
This function takes a list of Metadata components and sends them 
to Salesforce for creation or update if the object already exists
}
\note{
The upsert key is based on the fullName parameter of the metadata, so updates are triggered
when an existing Salesforce element matches the metadata type and fullName.
}
\examples{
\dontrun{
# create an object that we can confirm the update portion of the upsert
base_obj_name <- "Custom_Account1"
custom_object <- list()
custom_object$fullName <- paste0(base_obj_name, "__c")
custom_object$label <- paste0(gsub("_", " ", base_obj_name))
custom_object$pluralLabel <- paste0(base_obj_name, "s")
custom_object$nameField <- list(displayFormat = 'AN-{0000}', 
                                label = paste0(base_obj_name, ' Number'), 
                                type = 'AutoNumber')
custom_object$deploymentStatus <- 'Deployed'
custom_object$sharingModel <- 'ReadWrite'
custom_object$enableActivities <- 'true'
custom_object$description <- paste0(base_obj_name, " created by the Metadata API")
custom_object_result <- sf_create_metadata(metadata_type = 'CustomObject',
                                           metadata = custom_object)
# now update the object that was created
upsert_metadata <- list(custom_object, custom_object)
upsert_metadata[[1]]$fullName <- 'Custom_Account1__c'
upsert_metadata[[1]]$label <- 'New Label Custom_Account1'
upsert_metadata[[1]]$pluralLabel <- 'Custom_Account1s_new'
upsert_metadata[[2]]$fullName <- 'Custom_Account2__c'
upsert_metadata[[2]]$label <- 'New Label Custom_Account2'
upsert_metadata[[2]]$pluralLabel <- 'Custom_Account2s_new'
upserted_custom_object_result <- sf_upsert_metadata(metadata_type = 'CustomObject',
                                                    metadata = upsert_metadata)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
