% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkField.R
\name{checkField}
\alias{checkField}
\title{Check that a setting parameter has a matching data field}
\usage{
checkField(fieldKey, settings, data)
}
\arguments{
\item{fieldKey}{a list (like those provided by \code{getSettingKeys())} defining the position of parameter in the settings object.}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}

\item{data}{A data frame to check for the specified field}
}
\value{
A list containing the results of the check following the format specified in \code{validateSettings()[["checkList"]]}
}
\description{
Checks that a single parameter from the settings list matches a field value in a specified data set
}
\details{
This function compares settings with field values as part of the \code{validateSettings()} function. More specifically, the function checks whether the \code{fieldKey} in a \code{settings} object matches a column/field combination in \code{"data"}. The function makes 2 major assumptions about the structure of the settings object. First, it assumes that the first value in fieldKey is "settingName_values" and there is a corresponding "settingName_col" setting that defines the column to search for field-level data. Second, it expects that the value specified by key/settings is a list, and that each value in the list is a field of the variable above.
}
\examples{
testSettings<-generateSettings(standard="AdAM")
fields<-list("measure_values","TB")
safetyGraphics:::checkField(fieldKey=fields,settings=testSettings, data=adlbc) 

}
\keyword{internal}
