% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixRes.R
\docType{class}
\name{SaemixRes-class}
\alias{SaemixRes-class}
\alias{SaemixRes}
\alias{plot,SaemixRes}
\alias{print,SaemixRes}
\alias{showall,SaemixRes}
\alias{show,SaemixRes}
\title{Class "SaemixRes"}
\description{
An object of the SaemixRes class, representing the results of a fit through the SAEM algorithm.
}
\section{Slots}{

\describe{
\item{\code{name.fixed}}{a vector containing the names of the fixed parameters in the model}

\item{\code{name.random}}{a vector containing the names of the random parameters in the model}

\item{\code{name.sigma}}{a vector containing the names of the parameters of the residual error model}

\item{\code{npar.est}}{the number of parameters estimated (fixed, random and residual)}

\item{\code{fixed.effects}}{a vector giving the estimated h(mu) and betas}

\item{\code{fixed.psi}}{a vector giving the estimated h(mu)}

\item{\code{betas}}{a vector giving the estimated mu}

\item{\code{betaC}}{a vector with the estimates of the fixed effects for covariates}

\item{\code{omega}}{the estimated variance-covariance matrix}

\item{\code{respar}}{the estimated parameters of the residual error model}

\item{\code{fim}}{the Fisher information matrix}

\item{\code{se.fixed}}{a vector giving the estimated standard errors of estimation for the fixed effect parameters}

\item{\code{se.omega}}{a vector giving the estimated standard errors of estimation for Omega}

\item{\code{se.cov}}{a matrix giving the estimated SE for each term of the covariance matrix (diagonal elements represent the SE on the variances of the random effects and off-diagonal elements represent the SE on the covariance terms)}

\item{\code{se.respar}}{a vector giving the estimated standard errors of estimation for the parameters of the residual variability}

\item{\code{parpop}}{a matrix tracking the estimates of the population parameters at each iteration}

\item{\code{allpar}}{a matrix tracking the estimates of all the parameters (including covariate effects) at each iteration}

\item{\code{indx.fix}}{the index of the fixed parameters (used in the estimation algorithm)}

\item{\code{indx.cov}}{the index of the covariance parameters (used in the estimation algorithm)}

\item{\code{indx.omega}}{the index of the random effect parameters (used in the estimation algorithm)}

\item{\code{indx.res}}{the index of the residual error model parameters (used in the estimation algorithm)}

\item{\code{MCOV}}{a matrix of covariates (used in the estimation algorithm)}

\item{\code{cond.mean.phi}}{a matrix giving the conditional mean estimates of phi (estimated as the mean of the conditional distribution)}

\item{\code{cond.mean.psi}}{a matrix giving the conditional mean estimates of psi (h(cond.mean.phi))}

\item{\code{cond.var.phi}}{a matrix giving the variance on the conditional mean estimates of phi (estimated as the variance of the conditional distribution)}

\item{\code{cond.mean.eta}}{a matrix giving the conditional mean estimates of the random effect eta}

\item{\code{cond.shrinkage}}{a vector giving the shrinkage on the conditional mean estimates of eta}

\item{\code{mean.phi}}{a matrix giving the population estimate (Ci*mu) including covariate effects}

\item{\code{map.psi}}{a matrix giving the MAP estimates of individual parameters}

\item{\code{map.phi}}{a matrix giving the MAP estimates of individual phi}

\item{\code{map.eta}}{a matrix giving the individual estimates of the random effects corresponding to the MAP estimates}

\item{\code{map.shrinkage}}{a vector giving the shrinkage on the MAP estimates of eta}

\item{\code{phi}}{phi}

\item{\code{psi.samp}}{a three-dimensional array with samples of psi from the conditional distribution}

\item{\code{phi.samp}}{a three-dimensional array with samples of phi from the conditional distribution}

\item{\code{phi.samp.var}}{a three-dimensional array with the variance of phi}

\item{\code{ll.lin}}{log-likelihood computed by lineariation}

\item{\code{aic.lin}}{Akaike Information Criterion computed by linearisation}

\item{\code{bic.lin}}{Bayesian Information Criterion computed by linearisation}

\item{\code{ll.is}}{log-likelihood computed by Importance Sampling}

\item{\code{aic.is}}{Akaike Information Criterion computed by Importance Sampling}

\item{\code{bic.is}}{Bayesian Information Criterion computed by Importance Sampling}

\item{\code{LL}}{a vector giving the conditional log-likelihood at each iteration of the algorithm}

\item{\code{ll.gq}}{log-likelihood computed by Gaussian Quadrature}

\item{\code{aic.gq}}{Akaike Information Criterion computed by Gaussian Quadrature}

\item{\code{bic.gq}}{Bayesian Information Criterion computed by Gaussian Quadrature}

\item{\code{predictions}}{a data frame containing all the predictions and residuals in a table format}

\item{\code{ypred}}{a vector giving the mean population predictions}

\item{\code{ppred}}{a vector giving the population predictions obtained with the MAP estimates}

\item{\code{ipred}}{a vector giving the individual predictions obtained with the MAP estimates}

\item{\code{icpred}}{a vector giving the individual predictions obtained with the conditional estimates}

\item{\code{ires}}{a vector giving the individual residuals obtained with the MAP estimates}

\item{\code{iwres}}{a vector giving the individual weighted residuals obtained with the MAP estimates}

\item{\code{icwres}}{a vector giving the individual weighted residuals obtained with the conditional estimates}

\item{\code{wres}}{a vector giving the population weighted residuals}

\item{\code{npde}}{a vector giving the normalised prediction distribution errors}

\item{\code{pd}}{a vector giving the prediction discrepancies}
}}

\section{Objects from the Class}{
 
An object of the SaemixData class can be created by using the function \code{\link{saemixData}} and contain the following slots:
}

\section{Methods}{

  \describe{
    \item{[<-}{\code{signature(x = "SaemixRes")}: replace elements of object}
    \item{[}{\code{signature(x = "SaemixRes")}: access elements of object}
    \item{initialize}{\code{signature(.Object = "SaemixRes")}: internal function to initialise object, not to be used}
    \item{print}{\code{signature(x = "SaemixRes")}: prints details about the object (more extensive than show)}
    \item{read}{\code{signature(object = "SaemixRes")}: internal function, not to be used }
    \item{showall}{\code{signature(object = "SaemixRes")}: shows all the elements in the object}
    \item{show}{\code{signature(object = "SaemixRes")}: prints details about the object}
    \item{summary}{\code{signature(object = "SaemixRes")}: summary of the results. Returns a list with a number of elements extracted from the results ().}
	 }
}

\examples{
methods(class="SaemixRes")

showClass("SaemixRes")

}
\references{
Comets  E, Lavenu A, Lavielle M. Parameter estimation in nonlinear mixed effect models using saemix, an R implementation of the SAEM algorithm. Journal of Statistical Software 80, 3 (2017), 1-41.

Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis 49, 4 (2005), 1020-1038.

Comets E, Lavenu A, Lavielle M. SAEMIX, an R version of the SAEM algorithm. 20th meeting of the Population Approach Group in Europe, Athens, Greece (2011), Abstr 2173.
}
\seealso{
\code{\link{saemixData}} \code{\link{SaemixModel}} \code{\link{saemixControl}} \code{\link{saemix}}
}
\author{
Emmanuelle Comets \email{emmanuelle.comets@inserm.fr}

Audrey Lavenu

Marc Lavielle.
}
\keyword{classes}
