% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sValues.R
\name{sValues}
\alias{sValues}
\alias{sValues.data.frame}
\alias{sValues.formula}
\alias{sValues.matrix}
\title{S-values: conventional model ambiguity measures}
\usage{
sValues(..., R2_bounds = c(0.1, 0.5, 1), favorites = NULL,
  R2_favorites = NULL, scale = TRUE)

\method{sValues}{formula}(formula, data, R2_bounds = c(0.1, 0.5, 1),
  favorites = NULL, R2_favorites = NULL, scale = TRUE, ...)

\method{sValues}{matrix}(m, R2_bounds = c(0.1, 0.5, 1), favorites = NULL,
  R2_favorites = NULL, scale = TRUE, ...)

\method{sValues}{data.frame}(df, R2_bounds = c(0.1, 0.5, 1),
  favorites = NULL, R2_favorites = NULL, scale = TRUE, ...)
}
\arguments{
\item{...}{arguments passed to other methods. The first argument should be a \code{formula} followed by a \code{data.frame};
alternatively, as a shortcut, you can omit the \code{formula} and provide only a \code{matrix} or 
a \code{data.frame}: in that case, the function will automatically consider the first column as the dependent variable 
and the rest as the independent variables.}

\item{R2_bounds}{a numeric vector with two or more R2 bounds to be considered in the analysis. The default values are
\code{c(0.1, 0.5, 1)}, proposed by Leamer (2014).}

\item{favorites}{\emph{optional} - a character vector that specifies the "favorite" varibles to be used in the analysis.
These variables will have different lower and upper R2 bounds as defined in the \code{R_favorites} argument.}

\item{R2_favorites}{\emph{optional} - a numeric vector with two or more R2 bounds for the "favorite" variables.}

\item{scale}{should the variables be scaled/standardized to zero mean and unit variance? 
The default is \code{TRUE}. If your data is already scaled/standardized you should set this to \code{FALSE}.}

\item{formula}{an object of the class \code{\link{formula}}: a symbolic description of the model to be fitted.}

\item{data}{needed only when you pass a formula as first parameter. An object of the class \code{\link{data.frame}} containing the variables used in the analysis.}

\item{m}{an object of class \code{\link{matrix}} with the dependent variable in the first column 
followed by the covariates. 
The matrix must have column names.}

\item{df}{an object of class \code{\link{data.frame}} with the dependent variable in the first column 
followed by the covariates.}
}
\value{
\code{sValues} returns an object a list of class "sValues" containing the main results of the analysis:

\itemize{ 
\item \code{info}: a \code{list} with the general information about the paramaters used in the analysis, such as the 
formula, the data, the bounds and favorite variables.

\item \code{simple}: a \code{list} with the results of the simple linear regressions for each variable.

\item \code{all}: the results of the linear regression with all variables.

\item \code{bayes}: a \code{list} with the results of the bayesian regression for each combination of the R2 bounds. 
Each bayesian regression includes the coefficient estimates, the variance-covariance matrix and the t-values.

\item \code{ext_bounds}: a \code{list} with the extreme bounds estimates for each combination of the R2 bounds.

\item \code{s_values}: a \code{data.frame} with the s_values for each combination of the R2 bounds.
}
}
\description{
The function \code{sValues} performs the extreme bound analysis proposed by Leamer (2014) and 
discussed in Leamer (2015). 
For further details see the package vignette.
}
\examples{
# growth regressions example
## All variables, No favorites
data(economic_growth)
eg_sv <- sValues(GR6096 ~ ., data = economic_growth)
eg_sv # prints results
plot(eg_sv, R2_bounds = c(0.5, 1))
plot(eg_sv, type = "beta_plot", variable = "P60", error_bar = TRUE)
coefs_eg <- coef(eg_sv) # extract coefficients
coefs_eg

##  only 14 variables
eg_sv_14 <-  sValues(GR6096 ~GDPCH60L + OTHFRAC + ABSLATIT + 
                       LT100CR + BRIT + GOVNOM1 + WARTIME + 
                       SCOUT + P60 + PRIEXP70 + OIL + 
                       H60 + POP1560 + POP6560, data = economic_growth)
eg_sv_14
coefs_eg_14 <- coef(eg_sv_14)

## With 14 favorites among all variables
favorites <- c("GDPCH60L", "OTHFRAC", "ABSLATIT", "LT100CR", 
              "BRIT", "GOVNOM1", "WARTIME", "SCOUT", 
              "P60", "PRIEXP70", "OIL", "H60", 
              "POP1560", "POP6560")
eg_sv_fav <- sValues(GR6096 ~ ., data = economic_growth, R2_bounds = c(0.5, 1),
                    favorites = favorites, R2_favorites = c(0.4, 0.8))
eg_sv_fav
plot(eg_sv_fav, R2_bounds = c(0.5, 1))
plot(eg_sv_fav, type = "beta_plot", variable = "P60", error_bar = TRUE)
coefs_eg_fav <- coef(eg_sv_fav)
coefs_eg_fav

}
\references{
Leamer, E. (2014). S-values: Conventional context-minimal measures of the sturdiness of regression coefficients. Working Paper

Leamer, E. (2015). S-values and bayesian weighted all-subsets regressions. European Economic Review.
}
\seealso{
\code{\link{coef.sValues}} to extract coefficients or statistics; 

\code{\link{print.sValues}} for printing;

\code{\link{summary.sValues}} for summaries;

\code{\link{plot.sValues}} for plots.
}

