% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatioPredictableComponents.R
\name{RatioPredictableComponents}
\alias{RatioPredictableComponents}
\title{Calculate ratio of predictable components (RPC)}
\usage{
RatioPredictableComponents(
  exp,
  obs,
  time_dim = "year",
  memb_dim = "member",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A numerical array with, at least, 'time_dim' and 'memb_dim' 
dimensions.}

\item{obs}{A numerical array with the same dimensions than 'exp' except the
'memb_dim' dimension.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'year'.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. The default value is 'member'.}

\item{na.rm}{A logical value indicating whether to remove NA values during
the computation. The default value is FALSE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
An array of the ratio of the predictable components. it has the same
 dimensions as 'exp' except 'time_dim' and 'memb_dim' dimensions.
}
\description{
This function computes the ratio of predictable components (RPC; Eade et al., 2014).
}
\examples{
exp <- array(data = runif(600), dim = c(year = 15, member = 10, lat = 2, lon = 2))
obs <- array(data = runif(60), dim = c(year = 15, lat = 2, lon = 2))
RatioPredictableComponents(exp, obs)

}
