% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffCorr.R
\name{DiffCorr}
\alias{DiffCorr}
\title{Compute the correlation difference and its significance}
\usage{
DiffCorr(
  exp,
  obs,
  ref,
  N.eff = NA,
  time_dim = "sdate",
  memb_dim = NULL,
  method = "pearson",
  alpha = NULL,
  handle.na = "return.na",
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numerical array of the forecast data with at least time 
dimension.}

\item{obs}{A named numerical array with the observations with at least time
dimension. The dimensions must be the same as "exp" except 'memb_dim'.}

\item{ref}{A named numerical array of the reference forecast data with at 
least time dimension. The dimensions must be the same as "exp" except 
'memb_dim'.}

\item{N.eff}{Effective sample size to be used in the statistical significance
test. It can be NA (and it will be computed with the s2dv:::.Eno), a 
numeric (which is used for all cases), or an array with the same dimensions
as "obs" except "time_dim" (for a particular N.eff to be used for each case)
. The default value is NA.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member 
dimension to compute the ensemble mean of the forecast and reference 
forecast. If it is NULL (default), the ensemble mean should be provided
directly to the function.}

\item{method}{A character string indicating the correlation coefficient to be
computed ("pearson" or "spearman"). The default value is "pearson".}

\item{alpha}{A numeric of the significance level to be used in the statistical
significance test. If it is a numeric, "sign" will be returned. If NULL, the
p-value will be returned instead. The default value is NULL.}

\item{handle.na}{A charcater string indicating how to handle missing values.
If "return.na", NAs will be returned for the cases that contain at least one
NA in "exp", "ref", or "obs". If "only.complete.triplets", only the time 
steps with no missing values in all "exp", "ref", and "obs" will be used. If
"na.fail", an error will arise if any of "exp", "ref", or "obs" contains any
NA. The default value is "return.na".}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list with:
\item{$diff.corr}{
 A numerical array of the correlation differences with the same dimensions as
 the input arrays except "time_dim" (and "memb_dim" if provided).
}
\item{$sign}{
 A logical array of the statistical significance of the correlation 
 differences with the same dimensions as the input arrays except "time_dim"
 (and "memb_dim" if provided). Returned only if "alpha" is a numeric.
}
\item{$p.val}{
 A numeric array of the p-values with the same dimensions as the input arrays
 except "time_dim" (and "memb_dim" if provided). Returned only if "alpha" is 
 NULL.
}
}
\description{
Compute the correlation difference between two deterministic forecasts. 
Positive values of the correlation difference indicate that the forecast is 
more skillful than the reference forecast, while negative values mean that 
the reference forecast is more skillful. The statistical significance of the 
correlation differences is computed with a one-sided test for equality of 
dependent correlation coefficients (Steiger, 1980; Siegert et al., 2017) using
effective degrees of freedom to account for the autocorrelation of the time 
series (von Storch and Zwiers, 1999).
}
\examples{
exp <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
obs <- array(rnorm(1000), dim = c(lat = 3, lon = 2, sdate = 50))
ref <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
res <- DiffCorr(exp, obs, ref, memb_dim = 'member')

}
\references{
Steiger, 1980; https://content.apa.org/doi/10.1037/0033-2909.87.2.245
Siegert et al., 2017; https://doi.org/10.1175/MWR-D-16-0037.1
von Storch and Zwiers, 1999; https://doi.org/10.1017/CBO9780511612336
}
