% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ryt_get_analytics.R
\name{ryt_get_analytics}
\alias{ryt_get_analytics}
\title{Get statistics from 'YouTube Analytics API'}
\usage{
ryt_get_analytics(
  start_date = Sys.Date() - 14,
  end_date = Sys.Date(),
  metrics = c("views", "estimatedMinutesWatched", "averageViewDuration",
    "averageViewPercentage", "subscribersGained"),
  dimensions = "day",
  filters = NULL
)
}
\arguments{
\item{start_date}{The start date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.}

\item{end_date}{The end date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.}

\item{metrics}{Character vector of YouTube Analytics metrics, such as views or likes,dislikes. See the \href{https://developers.google.com/youtube/analytics/channel_reports}{documentation} for channel reports or a list of the reports that you can retrieve and the metrics available in each report. The \href{https://developers.google.com/youtube/analytics/metrics}{Metrics document} contains definitions for all of the metrics.}

\item{dimensions}{Character vector of YouTube Analytics dimensions, such as video or ageGroup,gender. The \href{https://developers.google.com/youtube/analytics/dimensions}{Dimensions document} contains definitions for all of the dimensions.}

\item{filters}{Character vector of filters that should be applied when retrieving YouTube Analytics data. The \href{https://developers.google.com/youtube/analytics/channel_reports}{documentation} for channel reports reports identifies the dimensions that can be used to filter each report, and the \href{https://developers.google.com/youtube/analytics/dimensions}{Dimensions document} defines those dimensions.}
}
\value{
tibble with analytics data
}
\description{
The YouTube Analytics API enables you to generate custom reports containing YouTube Analytics data. The API supports reports for channels and for content owners.
}
\examples{
\dontrun{
# auth
ryt_auth()

# get list of your videos
videos <- ryt_get_video_list()

# function for loading video stat
get_videos_stat <- function(video_id) {

  data <- ryt_get_analytics(
    metrics = c('views', 'likes', 'dislikes', 'comments', 'shares'),
    filters = stringr::str_glue('video=={video_id}')
  )

  if ( nrow(data) > 0 ) {
    data <- mutate(data, video_id = video_id)
}
}

# load video stat
video_stat <- purrr::map_df(videos$id_video_id, get_videos_stat)

# join stat with video metadata
video_stat <- left_join(video_stat,
                        videos,
                        by = c("video_id" = "id_video_id")) \%>\%
              select(video_id,
                     title,
                     day,
                     views,
                     likes,
                     dislikes,
                     comments,
                     shares)
}
}
