% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigsearch.R
\name{bigsearch}
\alias{bigsearch}
\title{Request to download a large number of VertNet records.}
\usage{
bigsearch(specificepithet = NULL, genus = NULL, family = NULL,
  order = NULL, class = NULL, compact = FALSE, year = NULL,
  date = NULL, mappable = NULL, error = NULL, continent = NULL,
  cntry = NULL, stateprovince = NULL, county = NULL, island = NULL,
  igroup = NULL, inst = NULL, id = NULL, catalognumber = NULL,
  collector = NULL, type = NULL, hastypestatus = NULL, media = NULL,
  rank = NULL, tissue = NULL, resource = NULL, rfile, email,
  verbose = TRUE, ...)
}
\arguments{
\item{specificepithet}{Taxonomic specific epithet, e.g. (sapiens in Homo sapiens) (character)}

\item{genus}{Taxonomic genus (character)}

\item{family}{Taxonomic family (character)}

\item{order}{Taxonomic order (character)}

\item{class}{Taxonomic class (character)}

\item{compact}{Return a compact data frame (logical)}

\item{year}{Year (numeric) or range of years designated by comparison
operators "<", ">", "<=" or ">=". You can pass in more than one of these
queries, in a vector. See example below. (character)}

\item{date}{Event date associated with this occurrence record; yyyy-mm-dd
or the range yyyy-mm-dd/yyyy-mm-dd (character)}

\item{mappable}{Record includes valid coordinates in decimal latitude and
decimal longitude (logical)}

\item{error}{Coordinate uncertainty in meters (numeric) or range of uncertainty
values designated by comparison operators "<", ">", "<=" or ">=" (character)}

\item{continent}{Continent to search for occurrence (character)}

\item{cntry}{Country to search for occurrence (character)}

\item{stateprovince}{State or province to search for occurrence (character)}

\item{county}{County to search for occurrence (character)}

\item{island}{Island to search for occurrence (character)}

\item{igroup}{Island group to search for occurrence (character)}

\item{inst}{Code name for the provider/institution of record (character)}

\item{id}{Provider's unique identifier for this occurrence record (character)}

\item{catalognumber}{Provider's catalog number or other ID for this record (character)}

\item{collector}{Collector name (character)}

\item{type}{Type of record; "specimen" or "observation" (character)}

\item{hastypestatus}{Specimen associated with this record is identified as a
holotype, paratype, neotype, etc. (character)}

\item{media}{Record also references associated media, such as a film or video (logical)}

\item{rank}{TBD (numeric)}

\item{tissue}{Record is likely to reference tissues (logical)}

\item{resource}{Identifier for the resource/dataset from which the record was
indexed (character)}

\item{rfile}{A name for the results file that you will download (character). Required.}

\item{email}{An email address where you can be contacted when your records are
ready for download (character). Required.}

\item{verbose}{Print progress and information messages. Default: TRUE}

\item{...}{Curl arguments passed on to \code{\link[httr]{GET}}}
}
\value{
Prints messages on progress, but returns NULL
}
\description{
Specifies a termwise search (like \code{\link{searchbyterm}}) and requests that all available 
records be made available for download as a tab-delimited text file.
}
\details{
\code{\link{bigsearch}} allows you to request records as a tab-delimited text file.
   This is the best way to access a large number of records, such as when your search
   results indicate that >1000 records are available. You will be notified by email
   when your records are ready for download.
}
\section{Reading data}{

We suggest reading data in with \code{\link[data.table]{fread}} - as it's
very fast for the sometimes large datasets you will get from using this function, 
and is usually robust to formatting issues.
}
\examples{
\dontrun{
# replace "big@search.luv" with your own email address
bigsearch(genus = "ochotona", rf = "pikaRecords", email = "big@search.luv")

# Pass in curl options for curl debugging
library("httr")
bigsearch(genus = "ochotona", rfile = "pikaRecords", email = "big@search.luv", config=verbose())

# Use more than one year query
bigsearch(class = "aves", year = c(">=1976", "<=1986"), 
          rfile = "test-bigsearch1", email = "myrmecocystus@gmail.com")
}
}
\references{
\url{https://github.com/VertNet/webapp/wiki/The-API-search-function}
}

