% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvsummary.R
\name{summaries}
\alias{summaries}
\alias{rvsummary}
\alias{is.rvsummary}
\alias{as.rvsummary}
\alias{as.rvsummary.rv}
\alias{as.rvsummary.rvsummary}
\alias{as.rvsummary.data.frame}
\alias{as.data.frame.rvsummary}
\alias{print.rvsummary}
\alias{print.rvsummary_rvfactor}
\alias{as.double.rvsummary}
\title{Random Vector Summaries}
\usage{
as.rvsummary(x, ...)

is.rvsummary(x)

\method{as.rvsummary}{data.frame}(x, quantiles = rvpar("summary.quantiles.numeric"), ...)

\method{print}{rvsummary_rvfactor}(x, all.levels = FALSE, ...)
}
\arguments{
\item{x}{object to be coerced or tested}

\item{\dots}{further arguments passed to or from other methods.}

\item{quantiles}{quantiles to calculate and store in the object}

\item{all.levels}{logical; whether to print all levels or not (see below for
details)}
}
\value{
An object of class \code{rvsummary} \emph{and} of subclass
\code{rvsummary_numeric}, \code{rvsummary_integer},
\code{rvsummary_logical}, or \code{rvsummary_rvfactor}.
}
\description{
\code{rvsummary} is a class of objects that hold the summary information on
each scalar component of a random variable (quantiles, mean, sd, number of
simulations etc.)
}
\details{
The \code{rvsummary} class provides a means to store a concise
representation of the marginal posterior distributions of the vector
components.  By default, the 201 quantiles \preformatted{ 0, 0.005, 0.01,
0.015, ..., 0.990, 0.995, 1 } are saved for each vector component in an
\code{rvsummary} object.

\code{is.rvsummary} tests whether the object is an \code{rvsummary} object;
\code{as.rvsummary} coerces a random vector object to a \code{rvsummary}
object.

\code{as.data.frame} is another way to obtain the data frame that is
produced by the \code{summary} method.

A data frame that has the format of an \code{rv} summary can be coerced into
an \code{rvsummary}; if quantiles are not specified within the data frame,
quantiles from the Normal distribution are filled in, if the mean and s.d.
are given.

Therefore, the following (generic) functions work with \code{rvsummary}
objects: \code{rvmean}, \code{rvsd}, \code{rvvar}, \code{rvquantile},
\code{rnsims}, \code{sims}, and consequently any `rv-only' function that
depends only on these functions will work; e.g. \code{is.constant}, which
depends only on \code{rvnsims}.

The method \code{is.double} is provided for compatibility reasons; this is
needed in a function called by \code{plot.rvsummary}

The arithmetic operators and mathematical functions will not work with
\code{rvsummary} objects.

The \code{sims} method returns the quantiles.
}
\examples{

  x <- rvnorm(mean=1:12)
  sx <- as.rvsummary(x)
  print(sx)          # prints the summary of the rvsummary object
  length(sx)         # 12
  dim(sx)            # NULL
  dim(sx) <- c(3,4)  #   
  dimnames(sx) <- list(1:3, 1:4)
  names(sx) <- 1:12  # 
  print(sx)          # prints the names and dimnames as well  

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{rvfactor}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
