% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvcut.R
\name{rvcut}
\alias{rvcut}
\alias{rvcut.rv}
\title{Convert Numeric to Random Factor}
\usage{
rvcut(x, ...)
}
\arguments{
\item{x}{a plain or a random vector which is to be converted to a factor by
cutting.}

\item{\dots}{arguments passed to the function \code{\link{cut}}.}
}
\value{
A random factor.
}
\description{
Convert implements the `cut' function using random variables.
}
\examples{

  rvcut(rvnorm(1), breaks=c(-Inf,-2,-1,0,1,2,Inf))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{rvfactor}}, \code{\link{cut}}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
