% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{plot.ru}
\alias{plot.ru}
\title{Plot diagnostics for an ru object}
\usage{
\method{plot}{ru}(x, y, ..., n = ifelse(x$d == 1, 1001, 101), prob = c(0.1,
  0.25, 0.5, 0.75, 0.95, 0.99), ru_scale = FALSE)
}
\arguments{
\item{x}{an object of class "ru", a result of a call to \code{ru}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed on to \code{hist}, \code{lines},
\code{contour} or \code{points}.}

\item{n}{A number.  The meaning depends on the value of x$d.
\itemize{
  \item {For d = 1 : n + 1 is the number of abscissae in the trapezium
     method used to normalize the density.}
  \item {For d = 2 : an n by n regular grid is used to contour the density.}
}}

\item{prob}{Numeric vector. Only relevant for d = 2.  The contour lines are
drawn such that the respective probabilities that the variable lies
within the contour are approximately prob.}

\item{ru_scale}{A logical scalar.  Should we plot data and density on the
scale used in the ratio-of-uniforms algorithm (TRUE) or on the original
scale (FALSE)?
\code{hist} and \code{plot}.}
}
\description{
\code{plot} method for class "ru".  Can only be used when d = 1 or d = 2.
  For d = 1 a histogram of the simulated values is plotted with a the
  density function superimposed.  The density is normalized crudely using
  the trapezium rule.  For d = 2 a scatter plot of the simulated values
  is produced with density contours superimposed.
}
\details{
Note that \code{suppressWarnings} is used to avoid potential benign warnings
  caused by passing unused graphical parameters to \code{hist} and
  \code{lines} via \code{...}.
}
\examples{
# Log-normal density ----------------
x <- ru(logf = dlnorm, log = TRUE, d = 1, n = 1000, lower = 0, init = 1)

\dontrun{
plot(x)
}

# Improve appearance using arguments to plot() and hist()
\dontrun{
plot(x, breaks = seq(0, ceiling(max(x$sim_vals)), by = 0.25),
  xlim = c(0, 10))
}

# Two-dimensional normal with positive association ----------------
rho <- 0.9
covmat <- matrix(c(1, rho, rho, 1), 2, 2)
log_dmvnorm <- function(x, mean = rep(0, d), sigma = diag(d)) {
  x <- matrix(x, ncol = length(x))
  d <- ncol(x)
  - 0.5 * (x - mean) \%*\% solve(sigma) \%*\% t(x - mean)
}
x <- ru(logf = log_dmvnorm, sigma = covmat, d = 2, n = 1000, init = c(0, 0))

\dontrun{
plot(x)
}
}
\seealso{
\code{\link{summary.ru}} for summaries of the simulated values
  and properties of the ratio-of-uniforms algorithm.
}

