% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_example.R
\name{gpd_logpost}
\alias{gpd_logpost}
\title{Generalized Pareto posterior log-density}
\usage{
gpd_logpost(pars, ss)
}
\arguments{
\item{pars}{A numeric vector containing the values of the generalized Pareto
parameters sigma and xi.}

\item{ss}{A numeric list. Summary statistics to be passed to the generalized
Pareto log-likelihood.  Calculated using \code{gpd_sum_stats}}
}
\value{
A numeric scalar. The value of the log-likelihood.
}
\description{
Calculates the generalized Pareto posterior log-density based on a particular
prior for the generalized Pareto parameters, a Maximal Data Information
(MDI) prior truncated to xi >= -1 in order to produce a posterior
density that is proper.
}
\examples{
\dontrun{
# Sample data from a GP(sigma, xi) distribution
gpd_data <- rgpd(m = 100, xi = 0, sigma = 1)
# Calculate summary statistics for use in the log-likelihood
ss <- gpd_sum_stats(gpd_data)
# Calculate the generalized Pareto log-posterior
gpd_logpost(pars = c(1, 0), ss = ss)
}
}
\references{
Northrop, P. J. and Attalides, N. (2016) Posterior propriety in
Bayesian extreme value analyses using reference priors. Statistica Sinica,
26(2), 721-743, \url{http://dx.doi.org/10.5705/ss.2014.034}.
}
\seealso{
\code{\link{gpd_sum_stats}} to calculate summary statistics for
  use in \code{gpd_loglik}.

\code{\link{rgpd}} for simulation from a generalized Pareto
}

