% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{NCA_find_col}
\alias{NCA_find_col}
\title{Determines Default Column Name}
\usage{
NCA_find_col(
  curr_ana = NULL,
  curr_ui = NULL,
  patterns = NULL,
  dscols,
  null_ok = FALSE
)
}
\arguments{
\item{curr_ana}{Current value in the analysis}

\item{curr_ui}{Current value in UI}

\item{patterns}{List of regular expression patterns to consider.}

\item{dscols}{Columns from the dataset.}

\item{null_ok}{Logical value indicating if a null result (nothing found) is
OK (default: \code{FALSE})}
}
\value{
Name of column found based on the rules above.
}
\description{
Based on the current analysis, value from the UI, an optional
list of patterns to search, and column names from a dataset this function
tries to find a default value for a column in the analysis (e.g. subject id,
dose, concentration, etc).

Generally the following is done:
\itemize{
\item If curr_ui has a non-NULL, non-"" value it is compared to dscols. If it
is found there that value is returned.
\item If not then the patterns are considered. If the patterns from the YAML
file are not NULL they are compared sequentially to the columns names.
The first match found is returned.
\item If nothing is found then the first value of dscols is returned.
}
}
\examples{
library(ruminate)
# Module IDs                                                                   
id     = "NCA"                                                                 
id_UD  = "UD"                                                                  
id_DW  = "DW"                                                                  
id_ASM = "ASM"  
# We need session and input variables to be define                             
 sess_res = NCA_test_mksession()
                                                                               
# Extracting the session and input variables                                   
session      = sess_res$session                                                
input        = sess_res$input                                                  
react_state  = list()                                                          
                                                                               
# We also need configuration files                                             
FM_yaml_file  = system.file(package = "formods",  "templates", "formods.yaml") 
MOD_yaml_file = system.file(package = "ruminate", "templates", "NCA.yaml")     
                                                                               
# Getting the current module state                                             
state = NCA_fetch_state(id             = id,                                   
                       input           = input,                                
                       session         = session,                              
                       FM_yaml_file    = FM_yaml_file,                         
                       MOD_yaml_file   = MOD_yaml_file,                        
                       id_ASM          = id_ASM,                               
                       id_UD           = id_UD,                                
                       id_DW           = id_DW,                                
                       react_state     = react_state)                          
                                                                               
# Pulls out the active analysis                                                
current_ana = NCA_fetch_current_ana(state)

# This will get the dataset associated with this analysis
ds = NCA_fetch_ana_ds(state, current_ana)

# After making changes you can update those in the state
state = NCA_set_current_ana(state, current_ana)

# You can use this to check the current analysis
current_ana = NCA_process_current_ana(state)

# This will pull out the code for the module
fc_res = NCA_fetch_code(state)

# This will use patterns defined for the site to detect
# columns. In this example we are detecting the id column:
id_col = NCA_find_col(
  patterns = state[["MC"]][["detect_col"]][["id"]],
  dscols   = names(ds$DS))

# This creates a new analysis
state = NCA_new_ana(state)
}
