% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{GM_loglik_no_skew}
\alias{GM_loglik_no_skew}
\title{GARCH-MIDAS log-likelihood (no skewness)}
\usage{
GM_loglik_no_skew(param, daily_ret, mv_m, K, distribution, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of starting values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{distribution}{The conditional density to use for the innovations. At the moment, valid choices are "norm" and "std", for the Normal
and Student-t distributions.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the GARCH-MIDAS, according to two errors' conditional distributions: Normal and Student-t.
For details, see \insertCite{engle_ghysels_sohn_2013;textual}{rumidas} and \insertCite{conrad_lock_2015;textual}{rumidas}.
}
\examples{
# conditional density of the innovations: normal
# start_val<-c(alpha=0.01,beta=0.8,m=0,theta=0.1,w2=2)
# r_t<-sp500['2005/2010']
# mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
# sum(GM_loglik_no_skew(start_val,r_t,mv_m,K=12,distribution="norm"))

# conditional density of the innovations: Student-t
# start_val<-c(alpha=0.01,beta=0.8,m=0,theta=0.1,w2=2,shape=5)
# r_t<-sp500['2005/2010']
# mv_m<-mv_into_mat(r_t,indpro,K=12,"monthly")
# sum(GM_loglik_no_skew(start_val,r_t,mv_m,K=12,distribution="std"))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
