% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{get_collections}
\alias{get_collections}
\title{Get collections by user or status id.}
\usage{
get_collections(user, status_id = NULL, n = 200, cursor = NULL,
  parse = TRUE, token = NULL)
}
\arguments{
\item{user}{Screen name or user id of target user. Requests must
provide a value for one of user or status_id.}

\item{status_id}{Optional, the identifier of the tweet for which to
return results. Requests must provide a value for one of user or
status_id.}

\item{n}{Maximum number of results to return. Defaults to 200.}

\item{cursor}{Page identifier of results to retrieve. If parse = TRUE,
the next cursor value for any given request--if available--is stored
as an attribute, accessible via \code{\link{next_cursor}}}

\item{parse}{Logical indicating whether to convert response object
into nested list. Defaults to true.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}
}
\value{
Return object converted to nested list if parsed otherwise
  an HTTP response object is returned.
}
\description{
Find collections (themed grouping of statuses) created by specific user
or status id. Results include user, status, and collection features.
}
\examples{

\dontrun{

## lookup a specific collection
cnnc <- get_collections("cnn")

## inspect data
str(cnnc)

## by status id
wwe <- get_collections(status_id = "925172982313570306")

## inspect data
str(wwe)

}

}
