% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_DCt.R
\name{ANOVA_DCt}
\alias{ANOVA_DCt}
\title{Delta Ct ANOVA analysis}
\usage{
ANOVA_DCt(
  x,
  numOfFactors,
  numberOfrefGenes,
  block,
  alpha = 0.05,
  p.adj = "none",
  analyseAllTarget = TRUE
)
}
\arguments{
\item{x}{The input data frame containing experimental design columns, target gene
E/Ct column pairs, and reference gene E/Ct column pairs. Reference gene
columns must be located at the end of the data frame. See "Input data 
structure" in vignettes for details about data structure.}

\item{numOfFactors}{Integer. Number of experimental factor columns 
(excluding \code{rep} and optional \code{block}).}

\item{numberOfrefGenes}{Integer. Number of reference genes. Each reference gene
must be represented by two columns (E and Ct).}

\item{block}{Character. Block column name or \code{NULL}.
When a qPCR experiment is done in multiple qPCR plates, 
variation resulting from the plates may interfere with the actual amount of 
gene expression. One solution is to conduct each plate as a randomized block 
so that at least one replicate of each treatment and control is present 
on a plate. Block effect is usually considered as random and its interaction 
with any main effect is not considered.}

\item{alpha}{statistical level for comparisons}

\item{p.adj}{Method for p-value adjustment. See \code{\link[stats]{p.adjust}}.}

\item{analyseAllTarget}{Logical or character.
If \code{TRUE} (default), all detected target genes are analysed.
Alternatively, a character vector specifying the names (names of their 
Efficiency columns) of target genes to be analysed.}
}
\value{
An object containing expression table, lm models, ANOVA table, residuals, and raw data for each gene:
\describe{
\item{dCt expression table for all treatment combinations along with the per-gene statistical grouping}{\code{object$relativeExpression}}
\item{ANOVA table for treatments}{\code{object$perGene$gene_name$ANOVA_T}}
\item{ANOVA table factorial}{\code{object$perGene$gene_name$ANOVA_factorial}}
\item{lm ANOVA for tratments}{\code{object$perGene$gene_name$lm_T}}
\item{lm ANOVA factorial}{\code{object$perGene$gene_name$lm_factorial}}
\item{Residuals}{\code{resid(object$perGene$gene_name$lm_T)}}
}
}
\description{
Performs Delta Ct (dCt) analysis of the data from a 1-, 2-, or 3-factor experiment. 
Per-gene statistical grouping is also performed for all treatment (T) combinations.
}
\details{
The function returns analysis of variance components and the expression table which include these columns: gene (name 
of target genes), factor columns, dCt (mean weighted delta Ct for each 
treatment combination), RE (relative expression = 2^-dCt), log2FC 
(log(2) of relative expression), 
LCL (95\% lower confidence level), UCL (95\% upper confidence level),
se (standard error of the mean calculated from the weighted delta Ct (wDCt) values of each treatment combination),
Lower.se.RE (The lower limit error bar for RE which is 2^(log2(RE) - se)), 
Upper.se.RE (The upper limit error bar for RE which is 2^(log2(RE) + se)),
Lower.se.log2FC (The lower limit error bar for log2 RE), 
Upper.se.log2FC (The upper limit error bar for log2 RE), and sig (per-gene significance grouping letters).
}
\examples{
data <- read.csv(system.file("extdata", "data_3factor.csv", package = "rtpcr"))
res <- ANOVA_DCt(
  data,
  numOfFactors = 3,
  numberOfrefGenes = 1,
  block = NULL)
}
