% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTEST_DDCt.r
\name{TTEST_DDCt}
\alias{TTEST_DDCt}
\title{Delta Delta Ct method t-test analysis}
\usage{
TTEST_DDCt(
  x,
  numberOfrefGenes,
  Factor.level.order = NULL,
  paired = FALSE,
  var.equal = TRUE,
  p.adj = "none",
  order = "none",
  plotType = "RE"
)
}
\arguments{
\item{x}{A data frame containing experimental conditions, biological replicates, and
amplification efficiency and Ct values for target and reference genes.
The number of biological replicates must be equal across genes. If this 
is not true, or there are \code{NA} values use \code{ANODA_DDCt} function 
for independent samples or \code{REPEATED_DDCt} for paired samples.
See the package vignette for details on the required data structure.}

\item{numberOfrefGenes}{Integer specifying the number of reference genes used for normalization.}

\item{Factor.level.order}{Optional character vector specifying the order of factor levels.
If \code{NULL}, the first level of the factor column is used as the calibrator.}

\item{paired}{Logical; if \code{TRUE}, a paired t-test is performed.}

\item{var.equal}{Logical; if \code{TRUE}, equal variances are assumed and a pooled variance
estimate is used. Otherwise, Welch's t-test is applied.}

\item{p.adj}{Method for p-value adjustment. One of
\code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"},
\code{"BH"}, \code{"BY"}, \code{"fdr"}, or \code{"none"}. See \code{\link[stats]{p.adjust}}.}

\item{order}{Optional character vector specifying the order of genes in the output plot.}

\item{plotType}{Plot scale to use: \code{"RE"} for relative expression or
\code{"log2FC"} for log2 fold change.}
}
\value{
A list with the following components:
\describe{
  \item{Result}{Table containing RE values, log2FC, p-values, significance codes,
  confidence intervals, standard errors, and lower/upper SE limits.}
  \item{RE_Plot}{Bar plot of relative expression values.}
  \item{log2FC_Plot}{Bar plot of log2 fold change values.}
}
}
\description{
The \code{TTEST_DDCt} function performs fold change expression analysis based on
the \eqn{\Delta \Delta C_T} method using Student's t-test. It supports analysis
of one or more target genes evaluated under two experimental conditions
(e.g. control vs treatment).
}
\details{
Relative expression values are computed using one or more reference genes for normalization.
Both paired and unpaired experimental designs are supported.

Paired samples in quantitative PCR refer to measurements collected from the same
individuals under two different conditions (e.g. before vs after treatment),
whereas unpaired samples originate from different individuals in each condition.
Paired designs allow within-individual comparisons and typically reduce
inter-individual variability.

The function returns numerical summaries as well as bar plots based on either
relative expression (RE) or log2 fold change (log2FC).
}
\examples{
# Example data structure
data1 <- read.csv(system.file("extdata", "data_1factor_one_ref.csv", package = "rtpcr"))

# Unpaired t-test
TTEST_DDCt(
  data1,
  paired = FALSE,
  var.equal = TRUE,
  numberOfrefGenes = 1)

# With amplification efficiencies
data2 <- read.csv(system.file("extdata", "data_1factor_one_ref_Eff.csv", package = "rtpcr"))

TTEST_DDCt(
  data2,
  paired = FALSE,
  var.equal = TRUE,
  numberOfrefGenes = 1)

# Two reference genes
data3 <- read.csv(system.file("extdata", "data_1factor_Two_ref.csv", package = "rtpcr"))
TTEST_DDCt(
  data3,
  numberOfrefGenes = 2,
  var.equal = TRUE,
  p.adj = "BH")
}
\references{
Livak, K. J. and Schmittgen, T. D. (2001).
Analysis of Relative Gene Expression Data Using Real-Time Quantitative PCR
and the Double Delta CT Method.
\emph{Methods}, 25(4), 402–408.
doi:10.1006/meth.2001.1262

Ganger, M. T., Dietz, G. D., and Ewing, S. J. (2017).
A common base method for analysis of qPCR data and the application of
simple blocking in qPCR experiments.
\emph{BMC Bioinformatics}, 18, 1–11.

Yuan, J. S., Reed, A., Chen, F., and Stewart, N. (2006).
Statistical Analysis of Real-Time PCR Data.
\emph{BMC Bioinformatics}, 7, 85.
}
\author{
Ghader Mirzaghaderi
}
