% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.r
\name{multiplot}
\alias{multiplot}
\title{Multiple plot function}
\usage{
multiplot(..., cols = 1)
}
\arguments{
\item{...}{ggplot objects can be passed in ... or to plotlist (as a list of ggplot objects)}

\item{cols}{Number of columns in the panel}
}
\value{
A  multiple-plots plate
}
\description{
\code{multiplot} function combines multiple ggplot objects into a single plate.
}
\details{
Combining multiple ggplot objects into a single plate.
}
\examples{

a <- TTEST_DDCt(data_ttest, 
        numberOfrefGenes = 1)
p1 <- a$plot

out2 <- ANOVA_DCt(data_1factor, numberOfrefGenes = 1, block = NULL)$Result
p2 <- plotOneFactor(out2,
        x_col= 1,
        y_col= 2,
        Lower.se_col = 7,
        Upper.se_col = 8,
        letters_col = 11,
        show.groupingLetters = TRUE)
                    
multiplot(p1, p2, cols=2)

multiplot(p1, p2, cols=1)


}
\author{
gist.github.com/pedroj/ffe89c67282f82c1813d
}
