% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tika_html.R
\name{tika_html}
\alias{tika_html}
\title{Get Structured XHTML}
\usage{
tika_html(input, ...)
}
\arguments{
\item{input}{Character vector describing the paths and/or urls to the input documents.}

\item{...}{Other parameters to be sent to \code{tika()}.}
}
\value{
A character vector in the same order and with the same length as \code{input}, of unparsed \code{XHTML}. Unprocessed files are \code{as.character(NA)}.
}
\description{
If \code{output_dir} is specified, files will have the \code{.html} file extension.
}
\examples{
\donttest{
batch <- c(
 system.file("extdata", "jsonlite.pdf", package = "rtika"),
 system.file("extdata", "curl.pdf", package = "rtika"),
 system.file("extdata", "table.docx", package = "rtika"),
 system.file("extdata", "xml2.pdf", package = "rtika"),
 system.file("extdata", "R-FAQ.html", package = "rtika"),
 system.file("extdata", "calculator.jpg", package = "rtika"),
 system.file("extdata", "tika.apache.org.zip", package = "rtika")
)
html <- tika_html(batch)
}
}
