% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_aaa}
\alias{read_aaa}
\title{Read tab separated files with AAA spline data.}
\usage{
read_aaa(
  file,
  column_names,
  fan_lines = 42,
  coordinates = "cartesian",
  na_rm = FALSE,
  format = "long"
)
}
\arguments{
\item{file}{The path of the file with AAA data. It can also be a character vector with multiple paths as separate strings..}

\item{column_names}{The names of the columns without including the splines columns.}

\item{fan_lines}{The number of fan lines (the default is \code{42}).}

\item{coordinates}{A string specifying the coordinate system. Possible values are \code{"cartesian"} (the default) and \code{"polar"}.}

\item{na_rm}{Remove NAs (the default is \code{FALSE}).}

\item{format}{A string specifying the data format. Possible values are \code{"long"} and \code{"wide"} (the default is \code{"long"}).}
}
\value{
A tibble. An \code{.index} column is added which indexes (groups) each tongue contour.
}
\description{
It reads a file or a list of files with data exported from AAA. The data are
automatically transformed from a wide to a long format (each row has values
of X or Y axes for each fan line). The imported tibble can then be used for
plotting and statistical analysis.
}
\examples{
columns <- c("speaker","seconds","rec_date","prompt","label",
"TT_displacement","TT_velocity","TT_abs_velocity","TD_displacement",
"TD_velocity","TD_abs_velocity")
file_path <- system.file("extdata", "it01.tsv", package = "rticulate")

tongue <- read_aaa(file_path, columns, na_rm = TRUE)

}
