% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{get_valid_modes}
\alias{get_valid_modes}
\title{Get Valid Modes}
\usage{
get_valid_modes(modality)
}
\arguments{
\item{modality}{Character string specifying the modality. Either "bulk" or
"single-cell".}
}
\value{
A character vector containing the valid mode strings.
}
\description{
Returns a vector of possible modes for the supported model.
These modes represent different types of gene expression data that can be
generated by the Synthesize Bio API.
}
\examples{
# Get all supported modes
modes <- get_valid_modes(modality = "bulk")
print(modes)

# Check if a specific mode is supported
"sample generation" \%in\% get_valid_modes(modality = "single-cell")
}
