% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{predict_query}
\alias{predict_query}
\title{Predict Gene Expression}
\usage{
predict_query(query, raw_response = FALSE, as_counts = TRUE)
}
\arguments{
\item{query}{A list representing the query data to send to the API.
Use `get_valid_query()` to generate an example.}

\item{raw_response}{If you do not want the gene expression data extracted from the JSON
response set this to FALSE. Default is to return only the expression and metadata.}

\item{as_counts}{passed to extract_expression() function. Logical, if FALSE,
transforms the predicted expression counts into logCPM (default is TRUE, returning raw counts).}
}
\value{
A list with two data frames:
        - 'metadata': contains metadata for each sample
        - 'expression': contains expression data for each sample
Throws an error If the API request fails or the response structure is invalid.
}
\description{
Sends a query to the Synthesize Bio API (v2.0) for prediction
and retrieves gene expression samples. This function validates the query, sends it
to the API, and processes the response into usable data frames.
}
\examples{
# Set your API key (in practice, use a more secure method)
\dontrun{

# To start using pysynthbio, first you need to have an account with synthesize.bio.
# Go here to create one: https://app.synthesize.bio/

Sys.setenv(SYNTHESIZE_API_KEY = "your_api_key_here")

# Create a query
query <- get_valid_query()

# Request raw counts
result <- predict_query(query, as_counts = TRUE)

# Access the results
metadata <- result$metadata
expression <- result$expression

# Request log CPM transformed data
log_result <- predict_query(query, as_counts = FALSE)
log_expression <- log_result$expression

# Explore the top expressed genes in the first sample
head(sort(expression[1, ], decreasing = TRUE))
}
}
