% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{get_valid_modalities}
\alias{get_valid_modalities}
\title{Get Valid Modalities}
\usage{
get_valid_modalities()
}
\value{
A character vector containing the valid modality strings.
}
\description{
Returns a vector of possible output modalities for the supported model.
These modalities represent different types of gene expression data that can be
generated by the Synthesize Bio API. Note only version 2 can be accessed with this
version of the package. If you would like to use v1 models return to 1.x.x versions of this package.
}
\examples{
# Get all supported modalities
modalities <- get_valid_modalities()
print(modalities)

# Check if a specific modality is supported
"bulk_rna-seq" \%in\% get_valid_modalities()
}
