% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removePackage.R
\name{removePackage}
\alias{removePackage}
\alias{removePackage,ANY,character-method}
\alias{removePackage,ANY,missingOrNULL-method}
\alias{removePackage,ANY,Session-method}
\title{Removes package from SyncroSim installation}
\usage{
removePackage(name, session = NULL, force = FALSE)

\S4method{removePackage}{ANY,character}(name, session = NULL, force = FALSE)

\S4method{removePackage}{ANY,missingOrNULL}(name, session = NULL, force = FALSE)

\S4method{removePackage}{ANY,Session}(name, session = NULL, force = FALSE)
}
\arguments{
\item{name}{character. The name of the package to remove}

\item{session}{\code{\link{Session}} object. If \code{NULL} (default), 
\code{session()} will be used}

\item{force}{logical. If \code{TRUE}, remove without requiring confirmation from 
the user. Default is \code{FALSE}}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful 
removal) and \code{FALSE} upon failure.
}
\description{
Removes package from SyncroSim installation
}
\examples{
\donttest{
# Set SyncroSim Session
mySession <- session()

# Remove package from SyncroSim Session
removePackage("stsim", mySession, force = FALSE)
}

}
