% Generated by roxygen2 (4.0.1): do not edit by hand
\name{os_legislatorsearch}
\alias{os_legislatorsearch}
\title{Search Legislators on OpenStates.}
\usage{
os_legislatorsearch(state = NULL, first_name = NULL, last_name = NULL,
  chamber = NULL, active = NULL, term = NULL, district = NULL,
  party = NULL, page = NULL, per_page = NULL, fields = NULL,
  return = "table", key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{state}{state two-letter abbreviation (character)}

\item{first_name}{first name of legislator (character)}

\item{last_name}{last name of legislator (character)}

\item{chamber}{one of 'upper' or 'lower' (character)}

\item{active}{TRUE or FALSE (character)}

\item{term}{filter by legislators who served during a certain term (character)}

\item{district}{legislative district (character)}

\item{party}{democratic or republican (character)}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{return}{(character) One of table (default), list, or response (httr response object)}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}
}
\value{
List of output fields.
}
\description{
Search Legislators on OpenStates.
}
\examples{
\dontrun{
os_legislatorsearch(state = 'ca', party = 'democratic')
os_legislatorsearch(state = 'tx', party = 'democratic', active = TRUE)
os_legislatorsearch(state = 'nv', party = 'republican')
os_legislatorsearch(state = 'dc', chamber = 'upper')

os_legislatorsearch(state = 'ca', party = 'democratic', per_page=3)
}
}

