% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cw_dates}
\alias{cw_dates}
\title{Capitol words dates.json method. Search the congressional record for
instances of a word or phrase over time.}
\usage{
cw_dates(phrase = NULL, title = NULL, date = NULL, start_date = NULL,
  end_date = NULL, chamber = NULL, state = NULL, party = NULL,
  bioguide_id = NULL, congress = NULL, session = NULL, cr_pages = NULL,
  volume = NULL, page_id = NULL, n = NULL, mincount = NULL,
  granularity = NULL, percentages = "true", entity_type = NULL,
  entity_value = NULL, return = "table",
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{phrase}{Phrase to search.}

\item{date}{Show results for only the given date.}

\item{start_date}{Start date to search on.}

\item{end_date}{End date to search on.}

\item{chamber}{Chamber of congress, House or Senate.}

\item{state}{State, capital two-letter abbreviation (e.g., AK,AZ,NM).}

\item{party}{Political party (one of D,R,I).}

\item{bioguide_id}{Bioguide ID for politician (e.g., B000243)}

\item{key}{Your SunlightLabs API key; loads from .Rprofile.}

\item{...}{Further curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).}

\item{title}{Title of page to search.}

\item{congress}{Congressional session (e.g., 110,111,112)}

\item{session}{Session within the current congress (e.g., 1,2)}

\item{cr_pages}{No definition.}

\item{volume}{No definition.}

\item{page_id}{Page id.}

\item{n}{Size, not sure what this is.}

\item{percentages}{Include the percentage of mentions versus total words in
the result objects. Valid values: 'true', 'false' (default) (character)}

\item{mincount}{Only return results where mentions are at or above the supplied threshold}

\item{granularity}{The length of time covered by each result. Valid values:
'year', 'month', 'day' (default)}

\item{entity_type}{The entity type to get top phrases for. One of 'date', 'month', 'state', or
'legislator'.}

\item{entity_value}{The value of the entity given in \code{entity_type}. See Details.}
}
\value{
Data frame of observations by date.
}
\description{
Capitol words dates.json method. Search the congressional record for
instances of a word or phrase over time.
}
\details{
Formats for \code{entity_value} parameter are as follows:

\itemize{
 \item date: 2011-11-09
 \item month: 201111
 \item state: NY
 \item legislator (bioguide id): L000551
}
}
\examples{
\dontrun{
cw_dates(phrase='I would have voted', start_date='2001-01-20',
   end_date='2009-01-20', granularity='year', party='D')

cw_dates(phrase='united states', entity_type='state',
   entity_value='VA', granularity='year', party='D')

cw_dates(phrase='voting', start_date='2009-01-01',
   end_date='2009-04-30', granularity='month', party='R')
}
}

