% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cg_bills}
\alias{cg_bills}
\title{Gets details for bills.}
\usage{
cg_bills(query = NULL, bill_id = NULL, bill_type = NULL, number = NULL,
  congress = NULL, chamber = NULL, introduced_on = NULL,
  last_action_at = NULL, last_vote_at = NULL, last_version_on = NULL,
  highlight = NULL, history.active = NULL, history.active_at = NULL,
  history.house_passage_result = NULL,
  history.house_passage_result_at = NULL,
  history.senate_cloture_result = NULL,
  history.senate_cloture_result_at = NULL,
  history.senate_passage_result = NULL,
  history.senate_passage_result_at = NULL, history.vetoed = NULL,
  history.vetoed_at = NULL, history.house_override_result = NULL,
  history.house_override_result_at = NULL,
  history.senate_override_result = NULL,
  history.senate_override_result_at = NULL,
  history.awaiting_signature = NULL,
  history.awaiting_signature_since = NULL, history.enacted = NULL,
  history.enacted_at = NULL, sponsor.party = NULL,
  enacted_as.law_type = NULL, bill_type__in = NULL,
  history.house_passage_result__exists = NULL,
  history.senate_passage_result__exists = NULL, nicknames = NULL,
  keywords = NULL, sponsor_id = NULL, cosponsor_ids = NULL,
  cosponsors_count = NULL, withdrawn_cosponsors_count = NULL,
  withdrawn_cosponsor_ids = NULL, committee_ids = NULL,
  related_bill_ids = NULL, enacted_as.congress = NULL,
  enacted_as.number = NULL, fields = NULL, page = 1, per_page = 20,
  order = NULL, key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), return = "table", ...)
}
\arguments{
\item{query}{Allows wildcards, quoting for phrases, and nearby word operators (full reference).
You can also retrieve highlighted excerpts, and all normal operators and filters.}

\item{highlight}{(logical) If TRUE, looks for words in query param close to each other.}

\item{bill_id}{The unique ID for this bill. Formed from the bill_type, number, and congress.}

\item{bill_type}{The type for this bill. For the bill 'H.R. 4921', the bill_type represents the
'H.R.' part. Bill types can be: hr, hres, hjres, hconres, s, sres, sjres, sconres.}

\item{number}{The number for this bill. For the bill 'H.R. 4921', the number is 4921.}

\item{congress}{The Congress in which this bill was introduced. For example, bills introduced in
the '111th Congress' have a congress of 111.}

\item{chamber}{The chamber in which the bill originated.}

\item{introduced_on}{The date this bill was introduced.}

\item{last_action_at}{The date or time of the most recent official action. In the rare case that
there are no official actions, this field will be set to the value of introduced_on.}

\item{last_vote_at}{The date or time of the most recent vote on this bill.}

\item{last_version_on}{The date the last version of this bill was published. This will be set to
the introduced_on date until an official version of the bill's text is published.}

\item{nicknames}{An array of common nicknames for a bill that don't appear in official data.
These nicknames are sourced from a public dataset at unitedstates/bill-nicknames, and will only
appear for a tiny fraction of bills. In the future, we plan to auto-generate acronyms from bill
titles and add them to this array.}

\item{keywords}{A list of official keywords and phrases assigned by the Library of Congress.
These keywords can be used to group bills into tags or topics, but there are many of them (1,023
unique keywords since 2009, as of late 2012), and they are not grouped into a hierarchy. They
can be assigned or revised at any time after introduction.}

\item{sponsor_id}{The bioguide ID of the bill's sponsoring legislator, if there is one. It is
possible, but rare, to have bills with no sponsor.}

\item{cosponsor_ids}{An array of bioguide IDs for each cosponsor of the bill. Bills do not
always have cosponsors.}

\item{cosponsors_count}{The number of active cosponsors of the bill.}

\item{withdrawn_cosponsor_ids}{An array of bioguide IDs for each legislator who has withdrawn
their cosponsorship of the bill.}

\item{withdrawn_cosponsors_count}{The number of withdrawn cosponsors of the bill.}

\item{committee_ids}{A list of IDs of committees related to this bill.}

\item{related_bill_ids}{A list of IDs of bills that the Library of Congress has declared
'related'. Relations can be pretty loose, use this field with caution.}

\item{enacted_as.congress}{The Congress in which this bill was enacted into law.}

\item{enacted_as.law_type}{Whether the law is a public or private law. Most laws are public
laws; private laws affect individual citizens. 'public' or 'private'.}

\item{enacted_as.number}{The number the law was assigned.}

\item{history.active}{Whether this bill has had any action beyond the standard action all bills
get (introduction, referral to committee, sponsors' introductory remarks). Only a small
percentage of bills get this additional activity.}

\item{history.active_at}{If this bill got any action beyond initial introduction, the date or
time of the first such action. This field will stay constant even as further action occurs. For
the time of the most recent action, look to the last_action_at field.}

\item{history.house_passage_result}{The result of the last time the House voted on passage. Only
present if this vote occurred. 'pass' or 'fail'.}

\item{history.house_passage_result_at}{The date or time the House last voted on passage. Only
present if this vote occurred.}

\item{history.senate_cloture_result}{The result of the last time the Senate voted on cloture.
Only present if this vote occurred. 'pass' or 'fail'.}

\item{history.senate_cloture_result_at}{The date or time the Senate last voted on cloture. Only
present if this vote occurred.}

\item{history.senate_passage_result}{The result of the last time the Senate voted on passage.
Only present if this vote occurred. 'pass' or 'fail'.}

\item{history.senate_passage_result_at}{The date or time the Senate last voted on passage. Only
present if this vote occurred.}

\item{history.vetoed}{Whether the bill has been vetoed by the President. Always present.}

\item{history.vetoed_at}{The date or time the bill was vetoed by the President. Only present if
this happened.}

\item{history.house_override_result}{The result of the last time the House voted to override a
veto. Only present if this vote occurred. 'pass' or 'fail'.}

\item{history.house_override_result_at}{The date or time the House last voted to override a veto.
Only present if this vote occurred.}

\item{history.senate_override_result}{The result of the last time the Senate voted to override
a veto. Only present if this vote occurred. 'pass' or 'fail'.}

\item{history.senate_override_result_at}{The date or time the Senate last voted to override a
veto. Only present if this vote occurred.}

\item{history.awaiting_signature}{Whether the bill is currently awaiting the President's
signature. Always present.}

\item{history.awaiting_signature_since}{The date or time the bill began awaiting the President's
signature. Only present if this happened.}

\item{history.enacted}{Whether the bill has been enacted into law. Always present.}

\item{history.enacted_at}{The date or time the bill was enacted into law. Only present if this
happened.}

\item{sponsor.party}{XXX}

\item{bill_type__in}{XXX}

\item{history.house_passage_result__exists}{XXX}

\item{history.senate_passage_result__exists}{XXX}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}
}
\value{
Committee details including subcommittees and all members.
}
\description{
Data on bills in Congress goes back to 2009, and comes from a mix of sources:
\itemize{
 \item Scrapers at github.com/unitedstates for most data, including core status and history
 information.
 \item Bulk data at GPO's FDSys for version information, and full text.
 \item The House' MajorityLeader.gov and Senate Democrats' official site for notices of upcoming
 debate.
}
}
\details{
History: The history field includes useful flags and dates/times in a bill's life. The above is
a real-life example of H.R. 3590 - not all fields will be present for every bill. Time fields
can hold either dates or times - Congress is inconsistent about providing specific timestamps.
}
\examples{
\dontrun{
# Bill lookup (i.e., filter)
cg_bills(congress=113, history.enacted=TRUE)
cg_bills(history.active=TRUE, order='last_action_at')
cg_bills(sponsor.party='R', history.vetoed=TRUE)
cg_bills(enacted_as.law_type='private', order='history.enacted_at')
cg_bills(bill_type__in='hjres|sjres', history.house_passage_result__exists=TRUE,
   history.senate_passage_result__exists=TRUE)

# Bill search
cg_bills(query='health care')
cg_bills(query='health care', history.enacted=TRUE)
cg_bills(query='freedom of information')
cg_bills(query='"freedom of information" accountab*')
cg_bills(query='transparency accountability'~5, highlight=TRUE)

# Disable pagination
cg_bills(per_page='all')
}
}

