/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.VKMUtil;

public class SGGeneralizer {
    private SG initialSG;

    public SGGeneralizer(SG sg) {
        this.initialSG = sg;
    }

    private static SGNominalSelector copySelector(SGNominalSelector sel, Set values) {
        if (sel instanceof DefaultSGSelector) {
            return new DefaultSGSelector(sel.getAttribute(), values);
        }
        throw new UnsupportedOperationException("Selector " + sel + " cannot be copied!");
    }

    private static List collectOneValuedSGSelectors(SGDescription sgd) {
        if (!sgd.isEmpty()) {
            LinkedList<SGNominalSelector> oneValuedSGSelectors = new LinkedList<SGNominalSelector>();
            for (SGNominalSelector sel : sgd) {
                if (sel.getValues().size() > 1) {
                    Set<Value> values = sel.getValues();
                    for (Value val : values) {
                        oneValuedSGSelectors.add(SGGeneralizer.copySelector(sel, Collections.singleton(val)));
                    }
                    continue;
                }
                oneValuedSGSelectors.add(sel);
            }
            return oneValuedSGSelectors;
        }
        return Collections.EMPTY_LIST;
    }

    private static List convertOneValuedSGSelectorsToSGSelectorsSMCValues(List selectors) {
        if (!selectors.isEmpty()) {
            HashMap<Attribute, SGNominalSelector> attributeSelectorsMap = new HashMap<Attribute, SGNominalSelector>();
            HashMap<Attribute, LinkedList<Value>> attributeValuesMap = new HashMap<Attribute, LinkedList<Value>>();
            for (SGNominalSelector sel : selectors) {
                attributeSelectorsMap.put(sel.getAttribute(), sel);
                LinkedList<Value> values = (LinkedList<Value>)attributeValuesMap.get(sel.getAttribute());
                if (values == null) {
                    values = new LinkedList<Value>();
                    attributeValuesMap.put(sel.getAttribute(), values);
                }
                values.addAll(sel.getValues());
            }
            LinkedList<SGNominalSelector> result = new LinkedList<SGNominalSelector>();
            for (Map.Entry entry : attributeValuesMap.entrySet()) {
                Attribute attr = (Attribute)entry.getKey();
                HashSet values = new HashSet((Collection)entry.getValue());
                SGNominalSelector newSel = SGGeneralizer.copySelector((SGNominalSelector)attributeSelectorsMap.get(attr), values);
                result.add(newSel);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public static List computeAllGeneralizationsOfSelectorSets(Collection<? extends SGSelector> baseSelectors) {
        LinkedList<List> result = new LinkedList<List>();
        SGDescription baseSelectorsSGD = new SGDescription();
        baseSelectorsSGD.addAll(baseSelectors);
        List oneValuedSGSelectors = SGGeneralizer.collectOneValuedSGSelectors(baseSelectorsSGD);
        List powerSetOfSelectors = VKMUtil.computePowerSet(oneValuedSGSelectors);
        for (List oneValuedSelectorList : powerSetOfSelectors) {
            List mcSelectorList = SGGeneralizer.convertOneValuedSGSelectorsToSGSelectorsSMCValues(oneValuedSelectorList);
            if (mcSelectorList.isEmpty() || mcSelectorList.equals(baseSelectors)) continue;
            result.add(mcSelectorList);
        }
        return result;
    }

    public SGSet computeAllSGGeneralizations(double minSGQualityLimit, IQualityFunction qualityFunction) {
        KBestSGSet result = SGSets.createKBestSGSet(Integer.MAX_VALUE, minSGQualityLimit);
        List sgSelectors = SGGeneralizer.collectOneValuedSGSelectors(this.initialSG.getSGDescription());
        List powerSetOfSelectors = VKMUtil.computePowerSet(sgSelectors);
        for (List oneValuedSelectorList : powerSetOfSelectors) {
            List selectorList = SGGeneralizer.convertOneValuedSGSelectorsToSGSelectorsSMCValues(oneValuedSelectorList);
            if (selectorList.isEmpty() || selectorList.equals(sgSelectors)) continue;
            SG newSubgroup = (SG)this.initialSG.clone();
            SGDescription newSGDescription = new SGDescription();
            newSGDescription.addAll(selectorList);
            newSubgroup.setSGDescription(newSGDescription);
            newSubgroup.createStatistics(newSubgroup.getStatistics().getOptions());
            newSubgroup.updateQuality(qualityFunction);
            if (!result.isInKBestQualityRange(newSubgroup.getQuality())) continue;
            result.addByReplacingWorstSG(newSubgroup);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(VKMUtil.computePowerSet(Arrays.asList("a", "b", "c")));
        System.out.println(VKMUtil.computePowerSet(Arrays.asList("a", "b", "c", "d")));
    }
}

