% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_responses.R
\name{generate_item_responses_sqn}
\alias{generate_item_responses_sqn}
\title{Internals: simulating responding to item in a 'sequential' (IRTree) way}
\usage{
generate_item_responses_sqn(
  theta,
  scoringMatrix,
  slopes,
  intercepts,
  editResponse = NULL,
  decidingOnPreviousResponse = FALSE
)
}
\arguments{
\item{theta}{matrix of latent traits' values}

\item{scoringMatrix}{matrix describing scoring patterns on each latent trait}

\item{slopes}{vector of slope parameters of each trait}

\item{intercepts}{intercept parameters}

\item{editResponse}{optional function returning scoring matrix that should be
used instead that provided by \code{scoringMatrix}; this should be function
accepting two arguments: \code{response} - generated response (by the model
described with the first column of the \code{scoringMatrix}) that is supposed
to be \emph{edited} and \code{scoringMatrix} - current scoring matrix (to be
replaced)}

\item{decidingOnPreviousResponse}{logical value indicating whether first
column of provided scoring matrix describes making decision whether to
respond on the basis of responses to previous items or not (in this first
case \emph{negative} choice shouldn't reduce number of rows in a response
matrix)}
}
\value{
vector of responses on item
}
\description{
Function generates responses 'sequentially`, i.e. using IRTree
approach. It goes through consecutive columns of a scoring matrix,
calling \code{\link{generate_item_responeses_gpcm}} to get responses at
a given node of a tree and the recursively calls itself on subsets of
observations with a given response with reduced scoring matrix.
}
\section{Limitations}{

Because function internally relies on calling
\code{\link{generate_item_responeses_gpcm}}, no normal ogive models can be
used (this may be changed in the future versions).
}

\seealso{
\code{link{generate_test_responses}},
\code{\link{generate_item_responses_sml}},
\code{\link{generate_item_responeses_gpcm}}
}
