% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox_effsize.R
\name{wilcox_effsize}
\alias{wilcox_effsize}
\title{Wilcoxon Effect Size}
\usage{
wilcox_effsize(
  data,
  formula,
  comparisons = NULL,
  ref.group = NULL,
  paired = FALSE,
  alternative = "two.sided",
  mu = 0,
  ci = FALSE,
  conf.level = 0.95,
  ci.type = "perc",
  nboot = 1000,
  ...
)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{comparisons}{A list of length-2 vectors specifying the groups of
interest to be compared. For example to compare groups "A" vs "B" and "B" vs
"C", the argument is as follow: \code{comparisons = list(c("A", "B"), c("B",
"C"))}}

\item{ref.group}{a character string specifying the reference group. If
 specified, for a given grouping variable, each of the group levels will be
 compared to the reference group (i.e. control group).

 If \code{ref.group = "all"}, pairwise two sample tests are
 performed for comparing each grouping variable levels against all (i.e.
 basemean).}

\item{paired}{a logical indicating whether you want a paired test.}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.}

\item{mu}{a number specifying an optional parameter used to form the null hypothesis.}

\item{ci}{If TRUE, returns confidence intervals by bootstrap. May be slow.}

\item{conf.level}{The level for the confidence interval.}

\item{ci.type}{The type of confidence interval to use. Can be any of "norm",
"basic", "perc", or "bca". Passed to \code{boot::boot.ci}.}

\item{nboot}{The number of replications to use for bootstrap.}

\item{...}{Additional arguments passed to the functions
\code{coin::wilcoxsign_test()} (case of one- or paired-samples test) or
\code{coin::wilcox_test()} (case of independent two-samples test).}
}
\value{
return a data frame with some of the following columns: \itemize{
 \item \code{.y.}: the y variable used in the test. \item
 \code{group1,group2}: the compared groups in the pairwise tests. \item
 \code{n,n1,n2}: Sample counts. \item \code{effsize}: estimate of the effect
 size (\code{r} value). \item \code{magnitude}: magnitude of effect size.
 \item \code{conf.low,conf.high}: lower and upper bound of the effect size
 confidence interval.}
}
\description{
Compute Wilcoxon effect size (\code{r}) for: \itemize{ \item
 one-sample test (Wilcoxon one-sample signed-rank test); \item paired
 two-samples test (Wilcoxon two-sample paired signed-rank test) and \item
 independent two-samples test ( Mann-Whitney, two-sample rank-sum test). }

 It can also returns confidence intervals by bootstap.

 The effect size \code{r} is calculated as \code{Z} statistic divided by
 square root of the sample size (N) (\eqn{Z/\sqrt{N}}). The \code{Z} value is
 extracted from either \code{coin::wilcoxsign_test()} (case of one- or
 paired-samples test) or \code{coin::wilcox_test()} (case of independent
 two-samples test).

 Note that \code{N} corresponds to total sample size for independent samples
 test and to total number of pairs for paired samples test.

 The \code{r} value varies from 0 to close to 1. The interpretation values
 for r commonly in published litterature and on the internet are: \code{0.10
 - < 0.3} (small effect), \code{0.30 - < 0.5} (moderate effect) and \code{>=
 0.5} (large effect).
}
\examples{
if(require("coin")){

# One-sample Wilcoxon test effect size
ToothGrowth \%>\% wilcox_effsize(len ~ 1, mu = 0)

# Independent two-samples wilcoxon effect size
ToothGrowth \%>\% wilcox_effsize(len ~ supp)


# Paired-samples wilcoxon effect size
ToothGrowth \%>\% wilcox_effsize(len ~ supp, paired = TRUE)

# Pairwise comparisons
ToothGrowth \%>\% wilcox_effsize(len ~ dose)

# Grouped data
ToothGrowth \%>\%
  group_by(supp) \%>\%
  wilcox_effsize(len ~ dose)

}
}
\references{
Maciej Tomczak and Ewa Tomczak. The need to report effect size
 estimates revisited. An overview of some recommended measures of effect
 size. Trends in Sport Sciences. 2014; 1(21):19-25.
}
