% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstantools-package.R
\docType{package}
\name{rstantools-package}
\alias{rstantools-package}
\alias{rstantools}
\title{Tools for Developing \R Packages Interfacing with Stan}
\description{
\if{html}{
  \figure{stanlogo.png}{options: width="50" alt="mc-stan.org"}
} \emph{Stan Development Team}

The \pkg{rstantools} package provides various tools for developers of \R
packages interfacing with Stan (\url{https://mc-stan.org}), including
functions to set up the required package structure, S3 generic methods to
unify function naming across Stan-based \R packages, and vignettes with
guidelines for developers. To get started building a package see
\code{\link[=rstan_create_package]{rstan_create_package()}}.
}
\seealso{
\itemize{
\item Guidelines and recommendations for developers of \R packages
interfacing with Stan and a demonstration getting a simple package working
can be found in the vignettes included with \pkg{rstantools} and at
\href{https://mc-stan.org/rstantools/articles/}{mc-stan.org/rstantools/articles}.
}

\itemize{
\item After reading the guidelines for developers, if you have trouble setting up
your package let us know on the the \href{https://discourse.mc-stan.org}{Stan Forums}
or at the \pkg{rstantools} GitHub \href{https://github.com/stan-dev/rstantools/issues}{issue tracker}.
}

Useful links:
\itemize{
  \item \url{https://mc-stan.org/rstantools/}
  \item \url{https://discourse.mc-stan.org/}
  \item Report bugs at \url{https://github.com/stan-dev/rstantools/issues}
}

}
\author{
\strong{Maintainer}: Jonah Gabry \email{jsg2201@columbia.edu}

Authors:
\itemize{
  \item Ben Goodrich \email{benjamin.goodrich@columbia.edu}
  \item Martin Lysy \email{mlysy@uwaterloo.ca}
  \item Andrew Johnson
}

Other contributors:
\itemize{
  \item Hamada S. Badr [contributor]
  \item Marco Colombo [contributor]
  \item Stefan Siegert [contributor]
  \item Trustees of Columbia University [copyright holder]
}

}
