% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_R2.R
\name{bayes_R2}
\alias{bayes_R2}
\alias{bayes_R2.default}
\title{Generic function and default method for Bayesian R-squared}
\usage{
bayes_R2(object, ...)

\method{bayes_R2}{default}(object, y, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods. See the methods in the \pkg{rstanarm}
package for examples.}

\item{y}{For the default method, a vector of \eqn{y} values the same length
as the number of columns in the matrix used as \code{object}.}
}
\value{
\code{bayes_R2} methods should return a vector of length equal to the
  posterior sample size.

  The default method just takes \code{object} to be a matrix of y-hat values
  (one column per observation, one row per posterior draw) and \code{y} to be
  a vector with length equal to \code{ncol(object)}.
}
\description{
Generic function and default method for Bayesian version of R-squared for
regression models. See \code{bayes_R2.stanreg} in the
\pkg{\link[rstanarm]{rstanarm}} package for an example of defining a method.
}
\seealso{
\itemize{
  \item The \pkg{\link[rstanarm]{rstanarm}} package for example methods
  (\href{https://CRAN.R-project.org/package=rstanarm}{CRAN},
  \href{https://github.com/stan-dev/rstanarm}{GitHub}).
}

\itemize{
  \item The guidelines for developers of \R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}. The document is also available online at the
  \pkg{rstantools} page on the
  \href{https://CRAN.R-project.org/package=rstantools/vignettes/developer-guidelines.html}{CRAN
  website}.
}
}
