% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privates.R
\name{.hasSubpaths}
\alias{.hasSubpaths}
\title{Subpaths Inclusion Checker}
\usage{
.hasSubpaths(f)
}
\arguments{
\item{f}{The set of forbidden paths, written as a data frame. Each row represents a path
as a sequence of nodes. Each row may be of different size, filling the empty cells with
\code{NA}. All nodes involved must be part of \code{g}, and no forbidden path can be of
size 2. This is because the latter is thought as an arc that should not exist in the
first place.}
}
\value{
\code{TRUE} if there is at least one subpath included in another forbidden path,
   \code{FALSE} otherwise.
}
\description{
Given a data frame of forbidden paths \code{f}, the function checks that no 
   subpath of any path is included in any other path. It only checks for subpaths of length 
   3, as it is the minimum combination that can be repeated
}
\details{
Private function that cannot be used by the package's end-users.
}
\seealso{
Other Private Functions: \code{\link{.comb}},
  \code{\link{.get_arc_attributes}},
  \code{\link{.nodesExists}}
}
\concept{Private Functions}
\keyword{internal}
