% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{direct_graph}
\alias{direct_graph}
\title{Undirected Graph Translator}
\usage{
direct_graph(graph, cores = 1L)
}
\arguments{
\item{graph}{An undirected graph written as a data frame, in which each rows represent an arc. 
The columns must be named \code{from} and \code{to}, and can be of any data type. Each row
can have additional attributes, and no cells can be \code{NULL} or \code{NA}.}

\item{cores}{This algorithm can be run using R's parallel processing functions. This variable
represents the number of processing cores you want to assign for the transformation. The 
default value is one single core. It is suggested to not assign all of your available cores
to the function.}
}
\value{
A new graph, with the same columns and data types of the original graph. This new
  graph is twice as big as the original, as new arcs are added to represent that each arc can 
  be traveled in both directions.
}
\description{
The SPPFP transformation functions only work with digraphs -i.e. directed graphs.
   Because in a digraph arcs can only be traveled in one direction, from the origin node to the
   destination arc, if undirected graphs are used as-is, the resultng G* will not be accurate.
   Therefore, this functions translates an undirected graph to a
   digraph by duplicating each arc and swapping the duplicate's \code{from} and \code{to} nodes.
}
\examples{
# Obtain the graph from any way
graph <- data.frame(from = c("s", "s", "s", "u", "u", "w", "w", "x", "x", "v", "v", "y", "y"), 
                    to = c("u", "w", "x", "w", "v", "v", "y", "w", "y", "y", "t", "t", "u"),
                    cost = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L),
                    stringsAsFactors = FALSE)
graph                    

# Translate it
digraph <- direct_graph(graph)
digraph


}
\seealso{
Other Parsers: \code{\link{get_all_nodes}},
  \code{\link{parse_vpath}}
}
\concept{Parsers}
