% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allphenotypes.R
\name{allphenotypes}
\alias{allphenotypes}
\title{Get all openSNP phenotypes, their variations, and how many users have data
available for a given phenotype.}
\usage{
allphenotypes(df = FALSE, ...)
}
\arguments{
\item{df}{Return a data.frame of all data. The column known_variations
can take multiple values, so the other columns id, characteristic, and
number_of_users are replicated in the data.frame. Default: \code{FALSE}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
data.frame of results, or list if \code{df=FALSE}
}
\description{
Either return data.frame with all results, or output a list, then call
the characteristic by id (parameter = "id") or name (parameter =
"characteristic").
}
\examples{
\dontrun{
# Get all data
allphenotypes(df = TRUE)

# Output a list, then call the characterisitc of interest by 'id' or
# 'characteristic'
datalist <- allphenotypes()
names(datalist) # get list of all characteristics you can call
datalist[["ADHD"]] # get data.frame for 'ADHD'
datalist[c("mouth size", "SAT Writing")] # get data.frame for 'ADHD'
}
}
\seealso{
Other opensnp-fxns: 
\code{\link{allgensnp}()},
\code{\link{annotations}()},
\code{\link{download_users}()},
\code{\link{fetch_genotypes}()},
\code{\link{genotypes}()},
\code{\link{phenotypes_byid}()},
\code{\link{phenotypes}()},
\code{\link{users}()}
}
\concept{opensnp-fxns}
