% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rsmlToPlant}
\alias{rsmlToPlant}
\title{Import a single RSML file into a Plant object}
\usage{
rsmlToPlant(rsml.path, threed = FALSE)
}
\arguments{
\item{rsml.path}{The path to the .rsml file. Mandatory.}

\item{threed}{Does the RSML file contains a 3D root system?}
}
\description{
Import a single RSML file into a Plant object
}
\examples{
# 2D example
path <- "http://rootsystemml.github.io/images/examples/arabidopsis-simple.rsml"
pl <- rsmlToPlant(path) # import the file as a 2D plant
plot(pl) # plot the plant

# 3D example
path <- "http://rootsystemml.github.io/images/examples/anagallis.rsml"
pl <- rsmlToPlant(path, threed=TRUE) # import the file as a 2D plant
plot(pl, threed=TRUE) # plot the plant
}
\keyword{3d}
\keyword{in}
\keyword{is}
\keyword{plant}
\keyword{rsml}
\keyword{the}
\keyword{threed}

