% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setKeyboardBindings.R
\name{setKeyboardBindings}
\alias{setKeyboardBindings}
\title{Set Rstudio keyboard bindings}
\usage{
setKeyboardBindings(overwrite = TRUE, removeLastYank = TRUE,
  workdir2filedir = TRUE)
}
\arguments{
\item{overwrite}{Logical. Should existing mappings on F3, F4, ..., F12
be overwritten? Still informs if this occurs. DEFAULT: TRUE}

\item{removeLastYank}{Logical. Should the annoying Rstudio default to override
"Redo" (CTRL+Y) with some weird yank be removed? 
DEFAULT: TRUE (Ctrl+Y becomes "Redo" again)}

\item{workdir2filedir}{Logical. Set CTRL+H for setWorkingDirToActiveDoc?
DEFAULT: TRUE}
}
\value{
Returns nothing
}
\description{
Set Rstudio keyboard bindings as mapped 
             on \url{https://github.com/brry/rskey#rskey}.
             \bold{By default, this overwrites existing F3:F12 mappings!}
}
\seealso{
\code{\link{addins}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2019
}
