% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{browse}
\alias{browse}
\title{browse}
\usage{
browse(prgs, simdf, n = (simdf[, 3] > 0), width.cutoff = 60, css = NULL)
}
\arguments{
\item{prgs}{sourcecode object}

\item{simdf}{similarity object}

\item{n}{integer: comparisons to show (default: \code{simf[,3]>0})}

\item{width.cutoff}{integer: an integer in [20, 500]: if a line's character length is at or over this number, the function will try to break it into a new line (default: \code{60})}

\item{css}{character: file name of CSS style for highlighting the R code}
}
\value{
invisibly the name of the temporary HTML file
}
\description{
Creates a temporary HTML file with source codes and opens it into a browser using \code{browseURL}.
Note that the source code is reformatted.
}
\examples{
# example files are taken from https://CRAN.R-project.org/package=SimilaR
files <- list.files(system.file("examples", package="rscc"), "*.R$", full.names=TRUE)
prgs  <- sourcecode(files)
simm  <- similarities(documents(prgs))
simdf <- matrix2dataframe(simm)
if (interactive()) browse(prgs, simdf)
}
