% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrrr.R
\name{cv.mrrr}
\alias{cv.mrrr}
\title{Mixed-response reduced-rank regression with rank selected by
cross validation}
\usage{
cv.mrrr(Y, X, is.pca = NULL, offset = NULL, ctrl.id = c(),
        family = list(gaussian(), binomial(), poisson()),
        familygroup = NULL, maxrank = min(ncol(Y), ncol(X)),
        penstr = list(), init = list(), control = list(), nfold = 5,
        foldid = NULL, nlam = 20, warm = FALSE)
}
\arguments{
\item{Y}{response matrix}

\item{X}{covariate matrix}

\item{is.pca}{If TRUE, mixed principal component analysis with X=I}

\item{offset}{matrix of the same dimension as Y for offset}

\item{ctrl.id}{indices of unpenalized predictors}

\item{family}{a list of family functions as used in \code{glm}}

\item{familygroup}{a list of family indices of the responses}

\item{maxrank}{integer giving the maximum rank allowed.}

\item{penstr}{a list of penalty structure of SVD.}

\item{init}{a list of initial values of kappaC0, kappaS0, C0, and S0}

\item{control}{a list of controling parameters for the fitting}

\item{nfold}{number of folds in cross validation}

\item{foldid}{to specify the folds if desired}

\item{nlam}{number of tuning parameters; not effective when using rank
constrained estimation}

\item{warm}{if TRUE, use warm start in fitting the solution paths}
}
\value{
S3 \code{mrrr} object, a list containing \item{fit}{the output from
    the selected model} \item{dev}{deviance measures}
}
\description{
Mixed-response reduced-rank regression with rank selected by
cross validation
}
\examples{
\dontrun{
library(rrpack)
simdata <- rrr.sim3(n = 100, p = 30, q.mix = c(5, 20, 5),
                    nrank = 2, mis.prop = 0.2)
Y <- simdata$Y
Y_mis <- simdata$Y.mis
X <- simdata$X
X0 <- cbind(1,X)
C <- simdata$C
family <- simdata$family
familygroup <- simdata$familygroup
svdX0d1 <- svd(X0)$d[1]
init1 = list(kappaC0 = svdX0d1 * 5)
offset = NULL
control = list(epsilon = 1e-4, sv.tol = 1e-2, maxit = 2000,
               trace = FALSE, gammaC0 = 1.1, plot.cv = TRUE,
               conv.obj = TRUE)
fit.cv.mrrr <- cv.mrrr(Y_mis, X, family = family,
                       familygroup = familygroup,
                       maxrank = 20,
                       penstr = list(penaltySVD = "rankCon",
                                     lambdaSVD = c(1 : 6)),
                       control = control, init = init1,
                       nfold = 10, nlam = 50)
summary(fit.cv.mrrr)
coef(fit.cv.mrrr)
fit.mrrr <- fit.cv.mrrr$fit

## plot(svd(fit.mrrr$coef[- 1,])$d)
plot(C ~ fit.mrrr$coef[- 1, ])
abline(a = 0, b = 1)
}
}
