% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refine_operations.R
\name{refine_rename_column}
\alias{refine_rename_column}
\title{Rename a column in OpenRefine project}
\usage{
refine_rename_column(
  original_name,
  new_name,
  project.name = NULL,
  project.id = NULL,
  verbose = FALSE,
  validate = TRUE,
  ...
)
}
\arguments{
\item{original_name}{Original name for the column}

\item{new_name}{New name for the column}

\item{project.name}{Name of project}

\item{project.id}{Unique identifier for project}

\item{verbose}{Logical specifying whether or not query result should be printed; default is \code{FALSE}}

\item{validate}{Logical as to whether or not the operation should validate parameters against existing data in project; default is \code{TRUE}}

\item{...}{Additional parameters to be inherited by \code{\link{refine_path}}; allows users to specify \code{host} and \code{port} arguments if the OpenRefine instance is running at a location other than \verb{http://127.0.0.1:3333}}
}
\value{
Operates as a side-effect passing operations to the OpenRefine instance. However, if \code{verbose=TRUE} then the function will return an object of the class "response".
}
\description{
This function allows users to rename an existing column in an OpenRefine project via an API query to \verb{/command/core/apply-operations} and the \code{core/column-rename} operation.
}
\examples{

\dontrun{
fp <- system.file("extdata", "lateformeeting.csv", package = "rrefine")
refine_upload(fp, project.name = "lfm")
refine_rename_column("what day whas it", "what_day_was_it", project.name = "lfm")
}


}
