% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile.R
\name{rray_tile}
\alias{rray_tile}
\title{Tile an array}
\usage{
rray_tile(x, times)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{times}{An integer vector. The number of times to repeat the
array along an axis.}
}
\value{
\code{x} with dimensions repeated as described by \code{times}.
}
\description{
Tile an array
}
\details{
\code{rray_tile()} should not be used as a replacement for \code{rray_broadcast()},
as it is generally less efficient.
}
\examples{

x <- matrix(1:5)

# Repeat the rows twice
rray_tile(x, 2)

# Repeat the rows twice and the columns three times
rray_tile(x, c(2, 3))

# Tile into a third dimension
rray_tile(x, c(1, 2, 2))

}
