% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagonal.R
\name{rray_diag}
\alias{rray_diag}
\title{Create a matrix with \code{x} on the diagonal}
\usage{
rray_diag(x, offset = 0)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{offset}{A single integer specifying the offset from the diagonal to
place \code{x}. This can be positive or negative.}
}
\value{
A matrix, with \code{x} on the diagonal.
}
\description{
\code{rray_diag()} creates a matrix filled with \code{x} on the diagonal. Use \code{offset}
to place \code{x} along an offset from the diagonal.
}
\details{
No dimension names will be on the result.
}
\examples{
# Creates a diagonal matrix
rray_diag(1:5)

# Offset `1:5` by 1
rray_diag(1:5, 1)

# You can also go the other way
rray_diag(1:5, -1)

# Identity matrix
rray_diag(rep(1, 5))

# One interesting use case of this is to create
# a square empty matrix with dimensions (offset, offset)
rray_diag(rray(integer()), 3)
rray_diag(logical(), 3)

}
