% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_indicator.R
\name{set_indicator}
\alias{set_indicator}
\title{Make a set indicator node.}
\usage{
set_indicator(
  source,
  rescol,
  testcol,
  testvalues,
  ...,
  translate_quotes = FALSE,
  env = parent.frame()
)
}
\arguments{
\item{source}{source to select from.}

\item{rescol}{name of column to land indicator in.}

\item{testcol}{name of column to check.}

\item{testvalues}{values to check for.}

\item{...}{force later arguments to bind by name}

\item{translate_quotes}{logical if TRUE translate quotes to SQL choice (simple replacement, no escaping).}

\item{env}{environment to look to.}
}
\value{
set_indicator node.
}
\description{
Create a new column indicating the membership of another column in a given set.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(),
                          ":memory:")

  d <- rq_copy_to(my_db, 'd',
                   data.frame(a = c("1", "2", "1", "3"),
                              b = c("1", "1", "3", "2"),
                              q = 1,
                              stringsAsFactors = FALSE),
                   temporary = TRUE,
                   overwrite = TRUE)
  # example
  set <- c("1", "2")
  op_tree <- d \%.>\%
    set_indicator(., "one_two", "a", set) \%.>\%
    set_indicator(., "z", "a", c())
  print(column_names(op_tree))
  print(columns_used(op_tree))
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))

  op_tree2 <- d \%.>\%
    set_indicator(., "one_two", "a", set) \%.>\%
    set_indicator(., "z", "b", c()) \%.>\%
    select_columns(., c("z", "one_two"))
  print(column_names(op_tree2))
  print(columns_used(op_tree2))

  # cleanup
  DBI::dbDisconnect(my_db)
}

}
