% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_source.R
\name{mk_td}
\alias{mk_td}
\alias{table_source}
\title{Make a table description directly.}
\usage{
mk_td(table_name, columns, ..., qualifiers = NULL, q_table_name = NULL)

table_source(table_name, columns, ..., qualifiers = NULL, q_table_name = NULL)
}
\arguments{
\item{table_name}{character, name of table}

\item{columns}{character, column names of table (non-empty and unique values).}

\item{...}{not used, force later argument to bind by name}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}

\item{q_table_name}{optional character, qualified table name, note: has to be re-generated for different DB connections.}
}
\value{
a relop representation of the data
}
\description{
Build minimal structures (table name and column names) needed to represent data from a remote table.
}
\details{
Generate a query that returns contents of a table, we
could try to eliminate this (replace the query with the table name),
but there are features one can work with with the query in place and
SQL optimizers likely make this zero-cost anyway.
}
\section{Functions}{
\itemize{
\item \code{table_source}: old name for mk_td
}}

\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  rq_copy_to(my_db,
             'd',
             data.frame(AUC = 0.6, R2 = 0.2),
             overwrite = TRUE,
             temporary = TRUE)
  d <- mk_td('d',
                    columns = c("AUC", "R2"))
  print(d)
  sql <- to_sql(d, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{db_td}}, \code{\link{local_td}}

\code{\link{db_td}}, \code{\link{local_td}}, \code{\link{rq_copy_to}}, \code{\link{materialize}}, \code{\link{execute}}, \code{\link{to_sql}}
}
