% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{counted_prevalence}
\alias{counted_prevalence}
\title{Count prevalence from registry data.}
\usage{
counted_prevalence(formula, index, data, start_date, status_col)
}
\arguments{
\item{formula}{A formula of the form <event date column> ~ <entry date column>.}

\item{index}{The date at which to estimate point prevalence as a string in the format
YYYY-MM-DD.}

\item{data}{A data frame with the corresponding column names provided in
\code{form}.}

\item{start_date}{The initial date to start counting prevalence from as a \code{Date} object.
Typically the index date - (Nyears * 365.25). Allows for non-whole year prevalence estimations.}

\item{status_col}{The name of the column holding a binary indicator variable
of whether the individual experienced an event at their event time or was
censored.}
}
\value{
The number of prevalent cases at the specified
index date as a single integer.
}
\description{
Counts contribution to prevalence at a specific index from each year of a
registry. A person is included as contributing to disease prevalence if they
are incident within the specified time-span, and are either alive or censored
at the index date. The rationale for including censored cases in prevalence
estimation is that such cases have typically been lost to follow-up, and are
often more likely to have been alive at the index date than not.
}
